/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.dmr.ModelNodes;
import org.infinispan.server.commons.naming.BinderServiceBuilder;
import org.infinispan.server.commons.service.AliasServiceBuilder;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.JGroupsBindingFactory;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;

public class JGroupsSubsystemAddHandler
extends AbstractAddStepHandler {
    JGroupsSubsystemAddHandler() {
        super(JGroupsSubsystemResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem();
        JGroupsSubsystemAddHandler.installRuntimeServices(context, operation, model);
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String defaultStack;
        ServiceTarget target = context.getServiceTarget();
        new ProtocolDefaultsBuilder().build(target).install();
        String defaultChannel = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.resolveModelAttribute(context, model), (String)"default");
        if (!defaultChannel.equals("default")) {
            for (ChannelServiceName factory : ChannelServiceName.values()) {
                new AliasServiceBuilder(factory.getServiceName(), factory.getServiceName(defaultChannel), Object.class).build(target).install();
            }
            new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding("default"), ChannelServiceName.CHANNEL.getServiceName(defaultChannel), JChannel.class).build(target).install();
            new AliasServiceBuilder(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName("default"), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultChannel), ChannelFactory.class).build(target).install();
            new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding("default"), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultChannel), ChannelFactory.class).build(target).install();
        }
        if (!(defaultStack = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model), (String)"default-stack")).equals("default-stack")) {
            new AliasServiceBuilder(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultStack), ChannelFactory.class).build(target).install();
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String defaultChannel;
        context.removeService(ProtocolDefaultsBuilder.SERVICE_NAME);
        String defaultStack = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model));
        if (defaultStack != null && !defaultStack.equals("default-stack")) {
            context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName());
        }
        if ((defaultChannel = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.resolveModelAttribute(context, model))) != null && !defaultChannel.equals("default")) {
            context.removeService(JGroupsBindingFactory.createChannelFactoryBinding("default").getBinderServiceName());
            context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName("default"));
            context.removeService(JGroupsBindingFactory.createChannelBinding("default").getBinderServiceName());
            for (ChannelServiceName factory : ChannelServiceName.values()) {
                context.removeService(factory.getServiceName());
            }
        }
    }
}

