/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

class JGroupsSchema {
    private static final String URN_PATTERN = "urn:%s:%d.%d";
    static final List<JGroupsSchema> SCHEMAS = new ArrayList<JGroupsSchema>();
    static final JGroupsSchema CURRENT;
    private final String domain;
    private final int major;
    private final int minor;

    private JGroupsSchema(String domain, int major, int minor) {
        this.domain = domain;
        this.major = major;
        this.minor = minor;
    }

    public boolean since(int major, int minor) {
        return this.major > major || this.major == major && this.minor >= minor;
    }

    public boolean since(JGroupsSchema ... schemas) {
        for (JGroupsSchema schema : schemas) {
            if (!this.domain.equals(schema.domain) || this.major <= schema.major && (this.major != schema.major || this.minor < schema.minor)) continue;
            return true;
        }
        return false;
    }

    public String getNamespaceUri() {
        return this.format(URN_PATTERN);
    }

    String format(String pattern) {
        return String.format(pattern, this.domain, this.major, this.minor);
    }

    static {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(JGroupsSchema.class.getResourceAsStream("/schema/infinispan-jgroups.namespaces"), StandardCharsets.UTF_8));){
            r.lines().forEach(line -> {
                int colon = line.lastIndexOf(58);
                String[] parts = line.substring(colon + 1).split("\\.");
                SCHEMAS.add(new JGroupsSchema(line.substring(0, colon), Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            });
            CURRENT = SCHEMAS.get(SCHEMAS.size() - 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

