/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.util.ByteIterator;

public class SaslClientCallbackHandler
implements CallbackHandler {
    private final String realm;
    private final String name;
    private final String credential;

    public SaslClientCallbackHandler(String realm, String name, String credential) {
        this.realm = realm;
        this.name = name;
        this.credential = credential;
    }

    public SaslClientCallbackHandler(String name, String credential) {
        int realmSep = name.indexOf(64);
        this.realm = realmSep < 0 ? "" : name.substring(realmSep + 1);
        this.name = realmSep < 0 ? name : name.substring(0, realmSep);
        this.credential = credential;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block8: for (Callback callback : callbacks) {
            ClearPassword password;
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.credential.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.name);
                continue;
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            if (!(callback instanceof CredentialCallback)) continue;
            CredentialCallback cb = (CredentialCallback)callback;
            switch (cb.getAlgorithm()) {
                case "clear": {
                    password = ClearPassword.createRaw((String)"clear", (char[])this.credential.toCharArray());
                    break;
                }
                case "digest-md5": {
                    byte[] decodedDigest = ByteIterator.ofBytes((byte[])this.credential.getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                    password = DigestPassword.createRaw((String)"digest-md5", (String)this.name, (String)this.realm, (byte[])decodedDigest);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            cb.setCredential((Credential)cb.getCredentialType().cast(new PasswordCredential((Password)password)));
        }
    }
}

