/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.server.rhq.MetricsRemappingComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class IspnCacheComponent
extends MetricsRemappingComponent<IspnCacheComponent>
implements CreateChildResourceFacet {
    static final String FLAVOR = "_flavor";

    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration config = report.getResourceConfiguration();
        String flavor = config.getSimpleValue(FLAVOR, null);
        if (flavor == null) {
            report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
            report.setErrorMessage("No flavor given");
            return report;
        }
        String newName = report.getUserSpecifiedResourceName();
        Address address = new Address(this.getAddress());
        address.add(flavor, newName);
        Operation add = new Operation("add", address);
        for (Property prop : config.getProperties()) {
            if (prop.getName().equals(FLAVOR)) continue;
            if (prop instanceof PropertyList) {
                List list = ((PropertyList)prop).getList();
                HashMap<String, String> properties = new HashMap<String, String>();
                for (Property property : list) {
                    if (!(property instanceof PropertyMap)) continue;
                    PropertyMap propertyMap = (PropertyMap)property;
                    properties.put(((PropertySimple)propertyMap.get("name")).getStringValue(), ((PropertySimple)propertyMap.get("value")).getStringValue());
                }
                ArrayList<HashMap<String, String>> propList = new ArrayList<HashMap<String, String>>();
                propList.add(properties);
                add.addAdditionalProperty(prop.getName(), propList);
                continue;
            }
            if (prop instanceof PropertySimple) {
                PropertySimple ps = (PropertySimple)prop;
                add.addAdditionalProperty(prop.getName(), (Object)ps.getStringValue());
                continue;
            }
            throw new IllegalArgumentException("Unsupported Property provided, was " + prop.getClass().getName());
        }
        Result result = this.getASConnection().execute(add);
        if (result.isSuccess()) {
            report.setResourceKey(address.getPath());
            report.setResourceName(address.getPath());
            report.setStatus(CreateResourceStatus.SUCCESS);
        } else {
            report.setErrorMessage(result.getFailureDescription());
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        return report;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Set<MeasurementScheduleRequest> requests = metrics;
        HashSet<MeasurementScheduleRequest> todo = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest req : requests) {
            if (req.getName().equals("__flavor")) {
                String flavor = this.getCacheFlavorFromPath();
                MeasurementDataTrait trait = new MeasurementDataTrait(req, flavor);
                report.addData(trait);
                continue;
            }
            todo.add(req);
        }
        super.getValues(report, todo);
    }

    private String getCacheFlavorFromPath() {
        String flavor = this.getPath().substring(this.getPath().lastIndexOf(",") + 1);
        flavor = flavor.substring(0, flavor.indexOf("="));
        return flavor;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = super.loadResourceConfiguration();
        String f = this.getCacheFlavorFromPath();
        PropertySimple flavor = new PropertySimple(FLAVOR, (Object)f);
        config.put((Property)flavor);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.getConfiguration().remove(FLAVOR);
        super.updateResourceConfiguration(report);
    }
}

