/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.server.rhq.MetricsRemappingComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;

public class IspnCacheComponent
extends MetricsRemappingComponent<IspnCacheComponent>
implements CreateChildResourceFacet {
    static final String FLAVOR = "_flavor";

    public CreateResourceReport createResource(CreateResourceReport report) {
        if ((report = super.createResource(report)).getStatus() == CreateResourceStatus.SUCCESS) {
            ConfigurationUpdateReport updateReport = new ConfigurationUpdateReport(report.getResourceConfiguration());
            ConfigurationDefinition configDef = report.getResourceType().getResourceConfigurationDefinition();
            Address address = new Address(this.getAddress());
            address.add(report.getPluginConfiguration().getSimpleValue("path"), report.getUserSpecifiedResourceName());
            ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), address);
            delegate.updateResourceConfiguration(updateReport);
            if (updateReport.getStatus() != ConfigurationUpdateStatus.SUCCESS) {
                report.setErrorMessage(updateReport.getErrorMessage());
                report.setStatus(CreateResourceStatus.FAILURE);
            }
        }
        return report;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Set<MeasurementScheduleRequest> requests = metrics;
        HashSet<MeasurementScheduleRequest> todo = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest req : requests) {
            if (req.getName().equals("__flavor")) {
                String flavor = this.getCacheFlavorFromPath();
                MeasurementDataTrait trait = new MeasurementDataTrait(req, flavor);
                report.addData(trait);
                continue;
            }
            todo.add(req);
        }
        super.getValues(report, todo);
    }

    private String getCacheFlavorFromPath() {
        String flavor = this.getPath().substring(this.getPath().lastIndexOf(",") + 1);
        flavor = flavor.substring(0, flavor.indexOf("="));
        return flavor;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = super.loadResourceConfiguration();
        String f = this.getCacheFlavorFromPath();
        PropertySimple flavor = new PropertySimple(FLAVOR, (Object)f);
        config.put((Property)flavor);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.getConfiguration().remove(FLAVOR);
        super.updateResourceConfiguration(report);
    }
}

