/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ConfigurationLoadDelegate
implements ConfigurationFacet {
    final Log log = LogFactory.getLog(this.getClass());
    private Address address;
    private ASConnection connection;
    private ConfigurationDefinition configurationDefinition;
    private String nameFromPathProperty;
    private boolean includeRuntime;

    public ConfigurationLoadDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this(configDef, connection, address, false);
    }

    public ConfigurationLoadDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address, boolean includeRuntime) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this.address = address;
        this.includeRuntime = includeRuntime;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        List gdef = this.configurationDefinition.getGroupDefinitions();
        for (PropertyGroupDefinition pgDef : gdef) {
            this.loadHandleGroup(config, pgDef);
        }
        List nonGroupdedDefs = this.configurationDefinition.getNonGroupedProperties();
        ReadResource op = new ReadResource(this.address);
        if (this.includeRuntime) {
            op.addAdditionalProperty("include-runtime", (Object)"true");
        }
        this.loadHandleProperties(config, nonGroupdedDefs, (Operation)op);
        return config;
    }

    private void loadHandleGroup(Configuration config, PropertyGroupDefinition groupDefinition) throws Exception {
        ReadAttribute operation = null;
        String groupName = groupDefinition.getName();
        if (groupName.startsWith("attribute:")) {
            String attr = groupName.substring("attribute:".length());
            operation = new ReadAttribute(this.address, attr);
        } else if (groupName.startsWith("children:")) {
            String type = groupName.substring("children:".length());
            if (type.contains(":")) {
                String tmp = type.substring(type.indexOf(":") + 1);
                if (tmp.endsWith("+-")) {
                    this.nameFromPathProperty = tmp.substring(0, tmp.length() - 2);
                }
                type = type.substring(0, type.indexOf(":"));
            }
            operation = new ReadChildrenResources(this.address, type);
            operation.addAdditionalProperty("recursive", (Object)"true");
        } else if (groupName.startsWith("child:")) {
            String subPath = groupName.substring("child:".length());
            if (!subPath.contains("=")) {
                throw new IllegalArgumentException("subPath of 'child:' expression has no =");
            }
            if (subPath.contains(":")) {
                subPath = subPath.substring(0, subPath.indexOf(58));
            }
            boolean includeRuntime = false;
            if (subPath.endsWith("*")) {
                subPath = subPath.substring(0, subPath.length() - 1);
                includeRuntime = true;
            }
            Address address1 = new Address(this.address);
            address1.addSegment(subPath);
            operation = new ReadResource(address1);
            if (includeRuntime) {
                ((ReadResource)operation).includeRuntime(true);
            }
        } else {
            ReadResource op = new ReadResource(this.address);
            if (this.includeRuntime) {
                op.includeRuntime(true);
            }
            List listedDefs = this.configurationDefinition.getPropertiesInGroup(groupName);
            this.loadHandleProperties(config, listedDefs, (Operation)op);
            return;
        }
        List listedDefs = this.configurationDefinition.getPropertiesInGroup(groupName);
        this.loadHandleProperties(config, listedDefs, (Operation)operation);
    }

    private void loadHandleProperties(Configuration config, List<PropertyDefinition> definitions, Operation op) throws Exception {
        if (definitions.size() == 0) {
            return;
        }
        Result operationResult = this.connection.execute(op);
        if (!operationResult.isSuccess()) {
            if (definitions.size() == 1 && !definitions.get(0).isRequired()) {
                return;
            }
            throw new IOException("Operation " + op + " failed: " + operationResult.getFailureDescription());
        }
        if (operationResult.getResult() instanceof List) {
            PropertyList propertyList = this.loadHandlePropertyList((PropertyDefinitionList)definitions.get(0), operationResult.getResult());
            if (propertyList != null) {
                config.put((Property)propertyList);
            }
            return;
        }
        Map results = (Map)operationResult.getResult();
        for (PropertyDefinition propDef : definitions) {
            Object valueObject;
            PropertyMap propertyMap;
            String propertyName = propDef.getName();
            if (propDef instanceof PropertyDefinitionList && propertyName.startsWith("*")) {
                if (!((propDef = ((PropertyDefinitionList)propDef).getMemberDefinition()) instanceof PropertyDefinitionMap)) {
                    this.log.error((Object)"Embedded child is not a map");
                    return;
                }
                PropertyList list = new PropertyList(propertyName);
                if (results != null) {
                    for (Map.Entry entry : results.entrySet()) {
                        Object val = entry.getValue();
                        String key = (String)entry.getKey();
                        PropertyMap propertyMap2 = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, val, key);
                        if (this.nameFromPathProperty != null) {
                            PropertySimple ps = new PropertySimple(this.nameFromPathProperty, (Object)key);
                            propertyMap2.put((Property)ps);
                        }
                        if (propertyMap2 == null) continue;
                        list.add((Property)propertyMap2);
                    }
                }
                config.put((Property)list);
                continue;
            }
            if (propDef instanceof PropertyDefinitionMap && propertyName.startsWith("*")) {
                Map mapResult = results;
                propertyMap = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, mapResult, propertyName);
                config.put((Property)propertyMap);
                continue;
            }
            if (propertyName.contains(":")) {
                try {
                    Integer.parseInt(propertyName.substring(propertyName.lastIndexOf(58) + 1));
                    propertyName = propertyName.substring(0, propertyName.lastIndexOf(58));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (propertyName.endsWith(":expr") || propertyName.endsWith(":collapsed") || propertyName.endsWith(":nullable")) {
                String realName = propertyName.substring(0, propertyName.indexOf(":"));
                valueObject = results.get(realName);
            } else {
                valueObject = results.get(propertyName);
            }
            if (propDef instanceof PropertyDefinitionSimple) {
                PropertySimple value = this.loadHandlePropertySimple((PropertyDefinitionSimple)propDef, valueObject);
                if (value == null) continue;
                config.put((Property)value);
                continue;
            }
            if (propDef instanceof PropertyDefinitionList) {
                PropertyList propertyList = this.loadHandlePropertyList((PropertyDefinitionList)propDef, valueObject);
                if (propertyList == null) continue;
                config.put((Property)propertyList);
                continue;
            }
            if (!(propDef instanceof PropertyDefinitionMap) || (propertyMap = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, valueObject, null)) == null) continue;
            config.put((Property)propertyMap);
        }
    }

    PropertySimple loadHandlePropertySimple(PropertyDefinitionSimple propDef, Object valueObject) {
        PropertySimple propertySimple;
        String name = propDef.getName();
        if (valueObject != null) {
            if (valueObject instanceof Map) {
                Object o = ((Map)valueObject).get("EXPRESSION_VALUE");
                propertySimple = new PropertySimple(name, o);
            } else {
                propertySimple = new PropertySimple(name, valueObject);
            }
        } else if (propDef.isRequired()) {
            String defaultValue = propDef.getDefaultValue();
            propertySimple = new PropertySimple(name, (Object)defaultValue);
        } else {
            propertySimple = new PropertySimple(name, null);
        }
        return propertySimple;
    }

    PropertyMap loadHandlePropertyMap(PropertyDefinitionMap propDefMap, Object valueObject, String optionalEntryName) {
        if (valueObject == null) {
            return null;
        }
        String propDefName = propDefMap.getName();
        PropertyMap propertyMap = new PropertyMap(propDefName);
        String specialNameProp = null;
        if (propDefName.startsWith("*:")) {
            specialNameProp = propDefName.substring(2);
            PropertySimple additionalNameProperty = new PropertySimple(specialNameProp, (Object)optionalEntryName);
            propertyMap.put((Property)additionalNameProperty);
        }
        List propDefs = propDefMap.getPropertyDefinitions();
        if (propDefName.endsWith(":collapsed")) {
            if (propDefs.size() < 1 || propDefs.size() > 2) {
                throw new IllegalArgumentException("Collapsed map [" + propDefName + "] needs 1 or 2 entries and not " + propDefs.size());
            }
            Iterator iterator = propDefs.iterator();
            String name = ((PropertyDefinition)iterator.next()).getName();
            Map objects = (Map)valueObject;
            String val = (String)objects.keySet().iterator().next();
            PropertySimple ps = new PropertySimple(name, (Object)val);
            propertyMap.put((Property)ps);
            if (iterator.hasNext()) {
                name = ((PropertyDefinition)iterator.next()).getName();
                val = (String)objects.values().iterator().next();
                ps = new PropertySimple(name, (Object)val);
                propertyMap.put((Property)ps);
            }
            return propertyMap;
        }
        Map objects = (Map)valueObject;
        for (PropertyDefinition propDef : propDefs) {
            PropertySimple property;
            Object o;
            String key = propDef.getName();
            if (key.equals(specialNameProp)) continue;
            if (key.equals("*")) {
                o = objects.entrySet().iterator().next().getValue();
            } else if (key.endsWith(":expr")) {
                String tmp = key.substring(0, key.indexOf(":"));
                o = objects.get(tmp);
            } else {
                o = objects.get(key);
            }
            if (propDef instanceof PropertyDefinitionSimple) {
                property = this.loadHandlePropertySimple((PropertyDefinitionSimple)propDef, o);
            } else if (propDef instanceof PropertyDefinitionList) {
                property = this.loadHandlePropertyList((PropertyDefinitionList)propDef, o);
            } else if (propDef instanceof PropertyDefinitionMap) {
                property = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, o, null);
            } else {
                throw new IllegalArgumentException("Unknown property type in map property [" + propDefName + "]");
            }
            if (property != null) {
                propertyMap.put((Property)property);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Property " + key + " was null"));
        }
        return propertyMap;
    }

    PropertyList loadHandlePropertyList(PropertyDefinitionList propDef, Object valueObject) {
        PropertyList propertyList;
        block5: {
            Collection<Object> objects;
            PropertyDefinition memberDefinition;
            block4: {
                String propertyName = propDef.getName();
                propertyList = new PropertyList(propertyName);
                memberDefinition = propDef.getMemberDefinition();
                if (memberDefinition == null) {
                    throw new IllegalArgumentException("Member definition for property [" + propertyName + "] was null");
                }
                if (valueObject == null) {
                    return null;
                }
                objects = valueObject instanceof List ? (List)valueObject : ((Map)valueObject).values();
                if (!(memberDefinition instanceof PropertyDefinitionSimple)) break block4;
                for (Object obj : objects) {
                    PropertySimple property = this.loadHandlePropertySimple((PropertyDefinitionSimple)memberDefinition, obj);
                    if (property == null) continue;
                    propertyList.add((Property)property);
                }
                break block5;
            }
            if (!(memberDefinition instanceof PropertyDefinitionMap)) break block5;
            for (Object obj : objects) {
                Map map = (Map)obj;
                PropertyMap propertyMap = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef.getMemberDefinition(), map, null);
                if (propertyMap == null) continue;
                propertyList.add((Property)propertyMap);
            }
        }
        return propertyList;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        throw new IllegalArgumentException("Please use ConfigurationWriteDelegate");
    }
}

