/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public abstract class MetricsRemappingComponent<T extends MetricsRemappingComponent<?>>
extends BaseComponent<T> {
    final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String INTERNAL = "_internal:";
    private static final int INTERNAL_SIZE = "_internal:".length();
    public static final Map<String, String> server2plugin = new HashMap<String, String>();
    public static final Map<String, String> plugin2server;

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            ReadAttribute op;
            if (req.getName().startsWith(INTERNAL)) {
                this.processPluginStats(req, report);
                continue;
            }
            String reqName = plugin2server.get(req.getName());
            if (reqName == null) {
                reqName = req.getName();
            }
            ComplexRequest request = null;
            if (reqName.contains(":")) {
                request = ComplexRequest.create(reqName);
                op = new ReadAttribute(this.getAddress(), request.getProp());
            } else {
                op = new ReadAttribute(this.getAddress(), reqName);
            }
            Result res = this.getASConnection().execute((Operation)op);
            if (!res.isSuccess()) {
                this.log.warn((Object)("Getting metric [" + req.getName() + "] at [ " + this.getAddress() + "] failed: " + res.getFailureDescription()));
                continue;
            }
            Object val = res.getResult();
            if (val == null) continue;
            if (req.getDataType() == DataType.MEASUREMENT) {
                if (val.equals("no metrics available")) continue;
                try {
                    if (request != null) {
                        HashMap myValues = (HashMap)val;
                        for (String key : myValues.keySet()) {
                            String sub;
                            if (!key.equals(sub = request.getSub())) continue;
                            this.addMetric2Report(report, req, myValues.get(key));
                        }
                        continue;
                    }
                    this.addMetric2Report(report, req, val);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Non numeric input for [" + req.getName() + "] : [" + val + "]"));
                }
                continue;
            }
            if (req.getDataType() != DataType.TRAIT) continue;
            String realVal = this.getStringValue(val);
            MeasurementDataTrait data = new MeasurementDataTrait(req, realVal);
            report.addData(data);
        }
    }

    private void processPluginStats(MeasurementScheduleRequest req, MeasurementReport report) {
        String name = req.getName();
        if (!name.startsWith(INTERNAL)) {
            return;
        }
        name = name.substring(INTERNAL_SIZE);
        PluginStats stats = PluginStats.getInstance();
        Double val = name.equals("mgmtRequests") ? Double.valueOf(stats.getRequestCount()) : (name.equals("requestTime") ? Double.valueOf(stats.getRequestTime()) : (name.equals("maxTime") ? Double.valueOf(stats.getMaxTime()) : Double.valueOf(Double.NaN)));
        MeasurementDataNumeric data = new MeasurementDataNumeric(req, val);
        report.addData(data);
    }

    private void addMetric2Report(MeasurementReport report, MeasurementScheduleRequest req, Object val) {
        Double d = Double.parseDouble(this.getStringValue(val));
        MeasurementDataNumeric data = new MeasurementDataNumeric(req, d);
        report.addData(data);
    }

    static {
        server2plugin.put("cache-manager-status", "cacheManagerStatus");
        server2plugin.put("defined-cache-count", "definedCacheCount");
        server2plugin.put("defined-cache-names", "definedCacheNames");
        server2plugin.put("running-cache-count", "runningCacheCount");
        server2plugin.put("created-cache-count", "createdCacheCount");
        server2plugin.put("cluster-name", "clusterName");
        server2plugin.put("cluster-size", "clusterSize");
        server2plugin.put("coordinator-address", "coordinatorAddress");
        server2plugin.put("is-coordinator", "isCoordinator");
        server2plugin.put("local-address", "localAddress");
        server2plugin.put("cache-status", "cacheStatus");
        server2plugin.put("cache-name", "cacheName");
        server2plugin.put("number-of-locks-available", "numberOfLocksAvailable");
        server2plugin.put("number-of-locks-held", "numberOfLocksHeld");
        server2plugin.put("concurrency-level", "concurrencyLevel");
        server2plugin.put("average-read-time", "averageReadTime");
        server2plugin.put("hit-ratio", "hitRatio");
        server2plugin.put("elapsed-time", "elapsedTime");
        server2plugin.put("read-write-ratio", "readWriteRatio");
        server2plugin.put("average-write-time", "averageWriteTime");
        server2plugin.put("average-remove-time", "averageRemoveTime");
        server2plugin.put("hits", "hits");
        server2plugin.put("evictions", "evictions");
        server2plugin.put("remove-misses", "removeMisses");
        server2plugin.put("time-since-reset", "timeSinceReset");
        server2plugin.put("number-of-entries", "numberOfEntries");
        server2plugin.put("stores", "stores");
        server2plugin.put("remove-hits", "removeHits");
        server2plugin.put("misses", "misses");
        server2plugin.put("success-ratio", "successRatio");
        server2plugin.put("replication-count", "replicationCount");
        server2plugin.put("replication-failures", "replicationFailures");
        server2plugin.put("average-replication-time", "averageReplicationTime");
        server2plugin.put("commits", "commits");
        server2plugin.put("prepares", "prepares");
        server2plugin.put("rollbacks", "rollbacks");
        server2plugin.put("invalidations", "invalidations");
        server2plugin.put("passivations", "passivations");
        server2plugin.put("activations", "activations");
        server2plugin.put("cache-loader-loads", "cacheLoaderLoads");
        server2plugin.put("cache-loader-misses", "cacheLoaderMisses");
        server2plugin.put("cache-loader-stores", "cacheLoaderStores");
        server2plugin.put("bytesRead", "bytesRead");
        server2plugin.put("bytesWritten", "bytesWritten");
        plugin2server = new HashMap<String, String>(server2plugin.size());
        for (Map.Entry<String, String> entry : server2plugin.entrySet()) {
            plugin2server.put(entry.getValue(), entry.getKey());
        }
    }

    private static class ComplexRequest {
        private String prop;
        private String sub;

        private ComplexRequest(String prop, String sub) {
            this.prop = prop;
            this.sub = sub;
        }

        public String getProp() {
            return this.prop;
        }

        public String getSub() {
            return this.sub;
        }

        public static ComplexRequest create(String requestName) {
            StringTokenizer tokenizer = new StringTokenizer(requestName, ":");
            return new ComplexRequest(tokenizer.nextToken(), tokenizer.nextToken());
        }
    }
}

