/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface JavaLog
extends Log {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="While trying to detect a crashed member, current view returned null", id=6000)
    public void viewNullWhileDetectingCrashedMember();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to update topology view after a crashed member left, wait for next view change.", id=6001)
    public void unableToUpdateView();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error detecting crashed member", id=6002)
    public void errorDetectingCrashedMember(@Cause Throwable var1);

    @Message(value="A topology cache named '%s' has already been defined", id=6003)
    public CacheConfigurationException invalidTopologyCache(String var1);

    @Message(value="Isolation level must be READ_COMMITTED or lower: '%s'", id=6004)
    public CacheConfigurationException invalidIsolationLevel(IsolationLevel var1);

    @Message(value="Cannot enable authentication without specifying a ServerAuthenticationProvider", id=6005)
    public CacheConfigurationException serverAuthenticationProvider();

    @Message(value="The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]", id=6006)
    public CacheConfigurationException invalidAllowedMechs(Set<String> var1, Set<String> var2);

    @Message(value="The requested operation is invalid", id=6007)
    public UnsupportedOperationException invalidOperation();

    @Message(value="A serverName must be specified when enabling authentication", id=6008)
    public CacheConfigurationException missingServerName();

    @Message(value="Event not handled by current Hot Rod event implementation: '%s'", id=6009)
    public IllegalStateException unexpectedEvent(Event var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6010)
    public void warnConditionalOperationNonTransactional(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6011)
    public void warnForceReturnPreviousNonTransactional(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Marshaller already set to '%s', ignoring passed '%s'", id=6012)
    public void warnMarshallerAlreadySet(Marshaller var1, Marshaller var2);
}

