/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public class MethodSignatureImpl
implements MethodSignature {
    private static final long serialVersionUID = 870948075030895317L;
    private final String methodName;
    private final String[] parameterTypes;

    public MethodSignatureImpl(AnnotatedMethod<?> method) {
        this.methodName = method.getJavaMember().getName();
        this.parameterTypes = new String[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            this.parameterTypes[i] = Reflections.getRawType(((AnnotatedParameter)method.getParameters().get(i)).getBaseType()).getName();
        }
    }

    public MethodSignatureImpl(Method method) {
        this.methodName = method.getName();
        this.parameterTypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.parameterTypes[i] = method.getParameterTypes()[i].getName();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignatureImpl) {
            MethodSignature that = (MethodSignature)obj;
            return this.getMethodName().equals(that.getMethodName()) && Arrays.equals(this.getParameterTypes(), that.getParameterTypes());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode += this.methodName.hashCode() * 5;
        return hashCode += Arrays.hashCode(this.parameterTypes) * 7;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String[] getParameterTypes() {
        return Arrays2.copyOf(this.parameterTypes, this.parameterTypes.length);
    }

    public String toString() {
        return new StringBuffer().append("method ").append(this.getMethodName()).append(Arrays.toString(this.getParameterTypes()).replace('[', '(').replace(']', ')')).toString();
    }
}

