/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.spi;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.serialization.impl.LuceneWorkSerializerImpl;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryBasedIndexManager
implements IndexManager {
    private static Log log = LoggerFactory.make();
    private String indexName;
    private DirectoryProvider directoryProvider;
    private Similarity similarity;
    private BackendQueueProcessor backend;
    private OptimizerStrategy optimizer;
    private LuceneIndexingParameters indexingParameters;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private LuceneWorkSerializer serializer;
    private SerializationProvider serializationProvider;
    private ExtendedSearchIntegrator boundSearchIntegrator = null;
    private DirectoryBasedReaderProvider readers = null;
    private ServiceManager serviceManager;

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readers;
    }

    @Override
    public void destroy() {
        this.readers.stop();
        this.backend.close();
        this.directoryProvider.stop();
        if (this.serializationProvider != null) {
            this.serviceManager.releaseService(SerializationProvider.class);
        }
    }

    @Override
    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext buildContext) {
        this.indexName = indexName;
        this.similarity = similarity;
        this.directoryProvider = this.createDirectoryProvider(indexName, properties, buildContext);
        this.indexingParameters = PropertiesParseHelper.extractIndexingPerformanceOptions(properties);
        this.optimizer = PropertiesParseHelper.getOptimizerStrategy(this, properties, buildContext);
        this.backend = this.createBackend(indexName, properties, buildContext);
        this.directoryProvider.start(this);
        this.readers = this.createIndexReader(indexName, properties, buildContext);
        this.serviceManager = buildContext.getServiceManager();
    }

    @Override
    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        this.backend.applyStreamWork(singleOperation, monitor);
    }

    @Override
    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.backend.applyWork(workList, monitor);
    }

    public String toString() {
        return "DirectoryBasedIndexManager [indexName=" + this.indexName + "]";
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.boundSearchIntegrator.getAnalyzer(name);
    }

    @Override
    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.boundSearchIntegrator = boundSearchIntegrator;
        this.triggerWorkspaceReconfiguration();
    }

    @Override
    public void addContainedEntity(Class<?> entity) {
        if (this.containedEntityTypes.add(entity)) {
            this.triggerWorkspaceReconfiguration();
        }
    }

    @Override
    public void optimize() {
        this.performStreamOperation(OptimizeLuceneWork.INSTANCE, null, false);
    }

    @Override
    public LuceneWorkSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializationProvider = this.serviceManager.requestService(SerializationProvider.class);
            this.serializer = new LuceneWorkSerializerImpl(this.serializationProvider, this.boundSearchIntegrator);
            log.indexManagerUsesSerializationService(this.indexName, this.serializer.describeSerializer());
        }
        return this.serializer;
    }

    public BackendQueueProcessor getBackendQueueProcessor() {
        return this.backend;
    }

    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return this.boundSearchIntegrator.getIndexBinding(entityType);
    }

    public Lock getDirectoryModificationLock() {
        return this.backend.getExclusiveWriteLock();
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public OptimizerStrategy getOptimizerStrategy() {
        return this.optimizer;
    }

    public LuceneIndexingParameters getIndexingParameters() {
        return this.indexingParameters;
    }

    private void triggerWorkspaceReconfiguration() {
        if (this.boundSearchIntegrator != null) {
            this.backend.indexMappingChanged();
        }
    }

    protected BackendQueueProcessor createBackend(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return BackendFactory.createBackend(this, buildContext, cfg);
    }

    protected DirectoryBasedReaderProvider createIndexReader(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return PropertiesParseHelper.createDirectoryBasedReaderProvider(this, cfg, buildContext);
    }

    protected DirectoryProvider createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return DirectoryProviderFactory.createDirectoryProvider(indexName, cfg, buildContext);
    }
}

