/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class AggregatedClassLoader
extends ClassLoader {
    private ClassLoader[] individualClassLoaders;

    public AggregatedClassLoader(ClassLoader ... classLoaders) {
        super(null);
        this.individualClassLoaders = classLoaders;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final HashSet<URL> resourceUrls = new HashSet<URL>();
        for (ClassLoader classLoader : this.individualClassLoaders) {
            Enumeration<URL> urls = classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                resourceUrls.add(urls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> resourceUrlIterator;
            {
                this.resourceUrlIterator = resourceUrls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.resourceUrlIterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.resourceUrlIterator.next();
            }
        };
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader classLoader : this.individualClassLoaders) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.findResource(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.individualClassLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (Exception ignore) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    public void destroy() {
        this.individualClassLoaders = null;
    }
}

