/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

@ThreadSafe
public class TLSProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private X509KeyManager keyManager;
    private X509TrustManager trustManager;
    private SSLContext sslContext;

    public TLSProtocolSocketFactory(X509KeyManager keyMgr, X509TrustManager trustMgr) throws IllegalArgumentException {
        this.keyManager = keyMgr;
        this.trustManager = trustMgr;
        try {
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, null);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error create SSL context", e);
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int clientPort) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port, localHost, clientPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams connParams) throws IOException {
        if (connParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = connParams.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.sslContext.getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localHost, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

