/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDefinition;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class DeploymentOverlayAdd
extends AbstractAddStepHandler {
    public static final DeploymentOverlayAdd INSTANCE = new DeploymentOverlayAdd();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (address.size() > 1) {
            String name = address.getLastElement().getValue();
            Resource deploymentOverlayResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)name)}));
        }
        super.execute(context, operation);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : DeploymentOverlayDefinition.attributes()) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        this.installServices(context, verificationHandler, newControllers, name);
    }

    void installServices(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name) {
        DeploymentOverlayService service = new DeploymentOverlayService(name);
        ServiceName serviceName = DeploymentOverlayService.SERVICE_NAME.append(new String[]{name});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

