/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.LifecycleCallbacks$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.TimeoutEnabledChannelInitializer;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0003\u0003Y!AF!cgR\u0014\u0018m\u0019;Qe>$xnY8m'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011\u0001B2pe\u0016T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a\u0002\u0015:pi>\u001cw\u000e\\*feZ,'\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0005\u00059An\\4hS:<\u0017BA\u000e\u0019\u0005\raun\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005a\u0001O]8u_\u000e|GNT1nKB\u0011qD\t\b\u0003\u001b\u0001J!!\t\b\u0002\rA\u0013X\rZ3g\u0013\t\u0019CE\u0001\u0004TiJLgn\u001a\u0006\u0003C9AQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015*!\t\u0019\u0002\u0001C\u0003\u001eK\u0001\u0007a\u0004C\u0005,\u0001\u0001\u0007\t\u0019!C\tY\u0005IAO]1ogB|'\u000f^\u000b\u0002[A\u0011a\u0006M\u0007\u0002_)\u00111FA\u0005\u0003c=\u0012aBT3uif$&/\u00198ta>\u0014H\u000fC\u00054\u0001\u0001\u0007\t\u0019!C\ti\u0005iAO]1ogB|'\u000f^0%KF$\"!\u000e\u001d\u0011\u000551\u0014BA\u001c\u000f\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u0003.\u0003)!(/\u00198ta>\u0014H\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0012y\nAbY1dQ\u0016l\u0015M\\1hKJ,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\tq!\\1oC\u001e,'/\u0003\u0002E\u0003\n!R)\u001c2fI\u0012,GmQ1dQ\u0016l\u0015M\\1hKJD\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011C$\u0002!\r\f7\r[3NC:\fw-\u001a:`I\u0015\fHCA\u001bI\u0011\u001dIT)!AA\u0002}BaA\u0013\u0001!B\u0013y\u0014!D2bG\",W*\u00198bO\u0016\u0014\b\u0005C\u0004M\u0001\u0001\u0007I\u0011C'\u0002\u001b\r|gNZ5hkJ\fG/[8o+\u0005q\u0005CA(Q\u001b\u0005\u0001\u0011BA)\u0015\u0005U\u0019V/\u001b;bE2,7i\u001c8gS\u001e,(/\u0019;j_:Dqa\u0015\u0001A\u0002\u0013EA+A\td_:4\u0017nZ;sCRLwN\\0%KF$\"!N+\t\u000fe\u0012\u0016\u0011!a\u0001\u001d\"1q\u000b\u0001Q!\n9\u000babY8oM&<WO]1uS>t\u0007\u0005C\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\u0006\u0001BO]1ogB|'\u000f^(cU:\u000bW.Z\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u000b[\u0006t\u0017mZ3nK:$(\"\u00011\u0002\u000b)\fg/\u0019=\n\u0005\tl&AC(cU\u0016\u001cGOT1nK\"IA\r\u0001a\u0001\u0002\u0004%I!Z\u0001\u0015iJ\fgn\u001d9peR|%M\u001b(b[\u0016|F%Z9\u0015\u0005U2\u0007bB\u001dd\u0003\u0003\u0005\ra\u0017\u0005\u0007Q\u0002\u0001\u000b\u0015B.\u0002#Q\u0014\u0018M\\:q_J$xJ\u00196OC6,\u0007\u0005C\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\u0006YQNY3b]N+'O^3s+\u0005a\u0007C\u0001/n\u0013\tqWLA\u0006N\u0005\u0016\fgnU3sm\u0016\u0014\b\"\u00039\u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0003=i'-Z1o'\u0016\u0014h/\u001a:`I\u0015\fHCA\u001bs\u0011\u001dIt.!AA\u00021Da\u0001\u001e\u0001!B\u0013a\u0017\u0001D7cK\u0006t7+\u001a:wKJ\u0004\u0003\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0003QI7o\u00127pE\u0006d7\u000b^1ug\u0016s\u0017M\u00197fIV\t\u0001\u0010\u0005\u0002\u000es&\u0011!P\u0004\u0002\b\u0005>|G.Z1o\u0011%a\b\u00011AA\u0002\u0013%Q0\u0001\rjg\u001ecwNY1m'R\fGo]#oC\ndW\rZ0%KF$\"!\u000e@\t\u000feZ\u0018\u0011!a\u0001q\"9\u0011\u0011\u0001\u0001!B\u0013A\u0018!F5t\u000f2|'-\u00197Ti\u0006$8/\u00128bE2,G\r\t\u0005\b\u0003\u000b\u0001A\u0011CA\u0004\u00035\u0019H/\u0019:u\u0013:$XM\u001d8bYR)Q'!\u0003\u0002\f!1A*a\u0001A\u00029Ca!PA\u0002\u0001\u0004y\u0004bBA\b\u0001\u0011\u0015\u0013\u0011C\u0001\u0006gR\f'\u000f\u001e\u000b\u0006k\u0005M\u0011Q\u0003\u0005\u0007\u0019\u00065\u0001\u0019\u0001(\t\ru\ni\u00011\u0001@\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tab\u001d;beR$&/\u00198ta>\u0014H\u000fF\u00016\u0011\u001d\ty\u0002\u0001C!\u0003C\tabZ3u\u0013:LG/[1mSj,'/\u0006\u0002\u0002$A1\u0011QEA\u001a\u0003oi!!a\n\u000b\t\u0005%\u00121F\u0001\bG\"\fgN\\3m\u0015\u0011\ti#a\f\u0002\u000b9,G\u000f^=\u000b\u0005\u0005E\u0012AA5p\u0013\u0011\t)$a\n\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0005\u0003K\tI$\u0003\u0003\u0002<\u0005\u001d\"aB\"iC:tW\r\u001c\u0005\b\u0003\u007f\u0001A\u0011CA\u000e\u0003Y\u0011XmZ5ti\u0016\u0014HK]1ogB|'\u000f^'CK\u0006t\u0007bBA\"\u0001\u0011E\u00111D\u0001\u0019k:\u0014XmZ5ti\u0016\u0014HK]1ogB|'\u000f^'CK\u0006t\u0007bBA$\u0001\u0011%\u0011\u0011J\u0001\u0011O\u0016$\u0018+^1mS\u001aLW\r\u001a(b[\u0016$\u0012A\b\u0005\b\u0003\u001b\u0002A\u0011IA(\u0003\u0011\u0019Ho\u001c9\u0016\u0003UBa!a\u0015\u0001\t\u0003q\u0014aD4fi\u000e\u000b7\r[3NC:\fw-\u001a:\t\r\u0005]\u0003\u0001\"\u0001N\u0003A9W\r^\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002\\\u0001!\t!!\u0018\u0002\u000f\u001d,G\u000fS8tiV\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0014\u0001\u00026bm\u0006L1aIA2\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\nqaZ3u!>\u0014H/\u0006\u0002\u0002tA\u0019Q\"!\u001e\n\u0007\u0005]dBA\u0002J]RDq!a\u001f\u0001\t\u0003\ti(A\tti\u0006\u0014H\u000fR3gCVdGoQ1dQ\u0016,\"!a \u0011\r\u0005\u0005\u00151\u0011\u0007\r\u001b\u00051\u0011bAAC\r\t)1)Y2iK\u0002")
public abstract class AbstractProtocolServer
implements ProtocolServer,
Log {
    private final String protocolName;
    private NettyTransport transport;
    private EmbeddedCacheManager cacheManager;
    private ProtocolServerConfiguration configuration;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;
    private boolean isGlobalStatsEnabled;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        AbstractProtocolServer abstractProtocolServer = this;
        synchronized (abstractProtocolServer) {
            if (!this.bitmap$0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return this.bitmap$0 ? this.org$infinispan$server$core$logging$Log$$log : this.org$infinispan$server$core$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Log$class.error(this, msg, t);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Log$class.warn(this, msg, t);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg) {
        Log$class.debug((Log)this, t, msg);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log$class.tracef(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    @Override
    public void logErrorBeforeReadingRequest(Throwable t) {
        Log$class.logErrorBeforeReadingRequest(this, t);
    }

    public NettyTransport transport() {
        return this.transport;
    }

    public void transport_$eq(NettyTransport x$1) {
        this.transport = x$1;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public ProtocolServerConfiguration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(ProtocolServerConfiguration x$1) {
        this.configuration = x$1;
    }

    private ObjectName transportObjName() {
        return this.transportObjName;
    }

    private void transportObjName_$eq(ObjectName x$1) {
        this.transportObjName = x$1;
    }

    private MBeanServer mbeanServer() {
        return this.mbeanServer;
    }

    private void mbeanServer_$eq(MBeanServer x$1) {
        this.mbeanServer = x$1;
    }

    private boolean isGlobalStatsEnabled() {
        return this.isGlobalStatsEnabled;
    }

    private void isGlobalStatsEnabled_$eq(boolean x$1) {
        this.isGlobalStatsEnabled = x$1;
    }

    public void startInternal(ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration_$eq(configuration);
        this.cacheManager_$eq(cacheManager);
        this.isGlobalStatsEnabled_$eq(cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
        if (this.isDebugEnabled()) {
            this.debugf((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting server with configuration: %s";
                }
            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration}));
        }
        this.startDefaultCache();
        this.startTransport();
    }

    @Override
    public final void start(ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        try {
            this.startInternal(configuration, cacheManager);
            return;
        }
        catch (Throwable throwable) {
            this.stop();
            throw throwable;
        }
    }

    public void startTransport() {
        InetSocketAddress address = new InetSocketAddress(this.configuration().host(), this.configuration().port());
        this.transport_$eq(new NettyTransport(this, this.getInitializer(), address, this.configuration(), this.getQualifiedName(), this.cacheManager()));
        this.registerTransportMBean();
        this.transport().start();
    }

    @Override
    public ChannelInitializer<Channel> getInitializer() {
        return this.configuration().idleTimeout() > 0 ? new TimeoutEnabledChannelInitializer(this, this.getEncoder()) : new NettyChannelInitializer(this, this.getEncoder());
    }

    public void registerTransportMBean() {
        GlobalConfiguration globalCfg = this.cacheManager().getCacheManagerConfiguration();
        this.mbeanServer_$eq(JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg));
        String groupName = new StringOps(Predef$.MODULE$.augmentString("type=Server,name=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getQualifiedName()}));
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer(), (String)groupName);
        ManageableComponentMetadata meta = LifecycleCallbacks$.MODULE$.componentMetadataRepo().findComponentMetadata(this.transport().getClass()).toManageableComponentMetadata();
        ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport(), meta);
        this.transportObjName_$eq(new ObjectName(new StringOps(Predef$.MODULE$.augmentString("%s:%s,component=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jmxDomain, groupName, meta.getJmxObjectName()}))));
        JmxUtil.registerMBean((Object)dynamicMBean, (ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
    }

    public void unregisterTransportMBean() {
        if (this.mbeanServer() != null && this.transportObjName() != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
        }
    }

    private String getQualifiedName() {
        return new StringBuilder().append((Object)this.protocolName).append((Object)(this.configuration().name().length() > 0 ? "-" : "")).append((Object)this.configuration().name()).toString();
    }

    @Override
    public void stop() {
        boolean isDebug = this.isDebugEnabled();
        if (isDebug && this.configuration() != null) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping server listening in %s:%d";
                }
            }, this.configuration().host(), (Object)BoxesRunTime.boxToInteger((int)this.configuration().port()));
        }
        if (this.transport() != null) {
            this.transport().stop();
        }
        this.unregisterTransportMBean();
        if (isDebug) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Server stopped";
                }
            });
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    @Override
    public ProtocolServerConfiguration getConfiguration() {
        return this.configuration();
    }

    public String getHost() {
        return this.configuration().host();
    }

    public int getPort() {
        return this.configuration().port();
    }

    public Cache<Object, Object> startDefaultCache() {
        return this.cacheManager().getCache(this.configuration().defaultCacheName());
    }

    public AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
        Log$class.$init$(this);
        this.configuration = null;
    }
}

