/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueInjectionService;

class EJBRemoteInvocationPassByValueWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJBRemoteInvocationPassByValueWriteHandler INSTANCE = new EJBRemoteInvocationPassByValueWriteHandler((AttributeDefinition)EJB3SubsystemRootResourceDefinition.PASS_BY_VALUE);
    private final AttributeDefinition attributeDefinition;

    private EJBRemoteInvocationPassByValueWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateDefaultLocalEJBReceiverService(context, model, null);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateDefaultLocalEJBReceiverService(context, restored, null);
    }

    void updateDefaultLocalEJBReceiverService(OperationContext context, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean passByValue;
        ModelNode passByValueModel = this.attributeDefinition.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceName localEJBReceiverServiceName = passByValueModel.isDefined() ? ((passByValue = passByValueModel.asBoolean(true)) ? LocalEjbReceiver.BY_VALUE_SERVICE_NAME : LocalEjbReceiver.BY_REFERENCE_SERVICE_NAME) : LocalEjbReceiver.BY_VALUE_SERVICE_NAME;
        ServiceController existingDefaultLocalEJBReceiverServiceController = registry.getService(LocalEjbReceiver.DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME);
        if (existingDefaultLocalEJBReceiverServiceController != null) {
            context.removeService(existingDefaultLocalEJBReceiverServiceController);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ValueInjectionService newDefaultLocalEJBReceiverService = new ValueInjectionService();
        ServiceBuilder defaultLocalEJBReceiverServiceBuilder = serviceTarget.addService(LocalEjbReceiver.DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME, (Service)newDefaultLocalEJBReceiverService);
        defaultLocalEJBReceiverServiceBuilder.addDependency(localEJBReceiverServiceName, LocalEjbReceiver.class, newDefaultLocalEJBReceiverService.getInjector());
        ServiceController defaultLocalEJBReceiverServiceController = defaultLocalEJBReceiverServiceBuilder.install();
        if (newControllers != null) {
            newControllers.add(defaultLocalEJBReceiverServiceController);
        }
    }
}

