/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerService;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class ProtocolServerMetricsHandler
extends AbstractRuntimeOnlyHandler {
    final String name;

    protected ProtocolServerMetricsHandler(String name) {
        this.name = name;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attrName = operation.require("name").asString();
        ProtocolServerMetrics metric = ProtocolServerMetrics.getStat(attrName);
        if (metric == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", attrName));
        } else {
            ServiceController controller = context.getServiceRegistry(false).getService(EndpointUtils.getServiceName(operation, this.name));
            ProtocolServerService service = (ProtocolServerService)controller.getService();
            ModelNode result = new ModelNode();
            switch (metric) {
                case BYTES_READ: {
                    result.set(service.getTransport().getTotalBytesRead());
                    break;
                }
                case BYTES_WRITTEN: {
                    result.set(service.getTransport().getTotalBytesWritten());
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    protected static void registerMetrics(ManagementResourceRegistration resourceRegistration, String name) {
        ProtocolServerMetricsHandler handler = new ProtocolServerMetricsHandler(name);
        for (ProtocolServerMetrics metric : ProtocolServerMetrics.values()) {
            resourceRegistration.registerMetric(metric.definition, (OperationStepHandler)handler);
        }
    }

    public static enum ProtocolServerMetrics {
        BYTES_READ((AttributeDefinition)new SimpleAttributeDefinitionBuilder("bytesRead", ModelType.LONG, true).setStorageRuntime().build()),
        BYTES_WRITTEN((AttributeDefinition)new SimpleAttributeDefinitionBuilder("bytesWritten", ModelType.LONG, true).setStorageRuntime().build());

        private static final Map<String, ProtocolServerMetrics> MAP;
        final AttributeDefinition definition;

        private ProtocolServerMetrics(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static ProtocolServerMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, ProtocolServerMetrics>();
            for (ProtocolServerMetrics stat : EnumSet.allOf(ProtocolServerMetrics.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }
}

