/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.List;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

class RestSubsystemAdd
extends AbstractAddStepHandler {
    private static final String DEFAULT_VIRTUAL_SERVER = "default-host";
    static final RestSubsystemAdd INSTANCE = new RestSubsystemAdd();

    RestSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        RestService service = new RestService(config);
        String virtualServer = config.hasDefined("virtual-server") ? config.get("virtual-server").asString() : DEFAULT_VIRTUAL_SERVER;
        String serverName = "default-server";
        ServiceName virtualHostServiceName = UndertowService.virtualHostName((String)serverName, (String)virtualServer);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "rest"), (Service)service);
        EndpointUtils.addCacheContainerDependency(builder, service.getCacheContainerName(), service.getCacheManager());
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector()).addDependency(virtualHostServiceName, Host.class, service.getHostInjector());
        if (service.getSecurityDomain() != null) {
            EndpointUtils.addSecurityDomainDependency(builder, service.getSecurityDomain(), service.getSecurityDomainContextInjector());
        }
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        RestSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition attr : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition attr : RestConnectorResource.REST_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

