/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common.v11;

import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;

public class ConnDefPoolImpl
extends CommonPoolImpl
implements ConnDefPool {
    private static final long serialVersionUID = 3L;
    private Integer initialPoolSize;
    private Capacity capacity;

    public ConnDefPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Capacity capacity) throws ValidateException {
        super(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy);
        this.initialPoolSize = initialPoolSize;
        this.capacity = capacity;
    }

    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.initialPoolSize == null ? 7 : 7 * this.initialPoolSize.hashCode());
        result = 31 * result + (this.capacity == null ? 7 : 7 * this.capacity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnDefPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ConnDefPoolImpl other = (ConnDefPoolImpl)obj;
        if (this.initialPoolSize == null ? other.initialPoolSize != null : !this.initialPoolSize.equals(other.initialPoolSize)) {
            return false;
        }
        return !(this.capacity == null ? other.capacity != null : !this.capacity.equals((Object)other.capacity));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(ConnDefPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(ConnDefPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(ConnDefPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(ConnDefPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(ConnDefPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(ConnDefPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(ConnDefPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(ConnDefPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(ConnDefPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(ConnDefPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(ConnDefPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(ConnDefPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.capacity != null) {
            sb.append("<").append(ConnDefPool.Tag.CAPACITY).append(">");
            sb.append(this.capacity);
            sb.append("</").append(ConnDefPool.Tag.CAPACITY).append(">");
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

