/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.MessageCounterInfo;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.impl.MessageCounterHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONException;
import org.hornetq.utils.json.JSONObject;

public class QueueControlImpl
extends AbstractControl
implements QueueControl {
    public static final int FLUSH_LIMIT = 500;
    private final Queue queue;
    private final String address;
    private final PostOffice postOffice;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private MessageCounter counter;

    private static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = QueueControlImpl.toJSONMsgArray(messages);
        return array.toString();
    }

    private static JSONArray toJSONMsgArray(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put((Object)new JSONObject(message));
        }
        return array;
    }

    private static String toJSON(Map<String, Map<String, Object>[]> messages) {
        try {
            JSONArray arrayReturn = new JSONArray();
            for (Map.Entry<String, Map<String, Object>[]> entry : messages.entrySet()) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("consumerName", (Object)entry.getKey());
                objectItem.put("elements", (Object)QueueControlImpl.toJSONMsgArray(entry.getValue()));
                arrayReturn.put((Object)objectItem);
            }
            return arrayReturn.toString();
        }
        catch (JSONException e) {
            return "Invalid conversion " + e.toString();
        }
    }

    public QueueControlImpl(Queue queue, String address, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        super(QueueControl.class, storageManager);
        this.queue = queue;
        this.address = address;
        this.postOffice = postOffice;
        this.addressSettingsRepository = addressSettingsRepository;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.clearIO();
        try {
            String string = this.queue.getName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getAddress() {
        this.checkStarted();
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = this.queue.getFilter();
            String string = filter != null ? filter.getFilterString().toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDurable() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isDurable();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemporary() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isTemporary();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsumerCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getConsumerCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeliveringCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getDeliveringCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesAdded() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAdded();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getID();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScheduledCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getScheduledCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeadLetterAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getDeadLetterAddress() != null) {
                String string = addressSettings.getDeadLetterAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (deadLetterAddress != null) {
                addressSettings.setDeadLetterAddress(new SimpleString(deadLetterAddress));
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpiryAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getExpiryAddress() != null) {
                String string = addressSettings.getExpiryAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiryAddress(String expiryAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            SimpleString sExpiryAddress = new SimpleString(expiryAddress);
            if (expiryAddress != null) {
                addressSettings.setExpiryAddress(sExpiryAddress);
            }
            this.queue.setExpiryAddress(sExpiryAddress);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object>[] listScheduledMessages() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<MessageReference> refs = this.queue.getScheduledMessages();
            Map<String, Object>[] mapArray = this.convertMessagesToMaps(refs);
            return mapArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listScheduledMessagesAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listScheduledMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    private Map<String, Object>[] convertMessagesToMaps(List<MessageReference> refs) {
        Map[] messages = new Map[refs.size()];
        int i = 0;
        for (MessageReference ref : refs) {
            ServerMessage message = ref.getMessage();
            messages[i++] = message.toMap();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>[]> listDeliveringMessages() {
        this.checkStarted();
        this.clearIO();
        try {
            Map<String, List<MessageReference>> msgs = this.queue.getDeliveringMessages();
            HashMap<String, Map<String, Object>[]> msgRet = new HashMap<String, Map<String, Object>[]>();
            for (Map.Entry<String, List<MessageReference>> entry : msgs.entrySet()) {
                msgRet.put(entry.getKey(), this.convertMessagesToMaps(entry.getValue()));
            }
            HashMap<String, Map<String, Object>[]> hashMap = msgRet;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listDeliveringMessagesAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listDeliveringMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Map[] mapArray;
            Filter filter = FilterImpl.createFilter(filterStr);
            ArrayList<Map> messages = new ArrayList<Map>();
            this.queue.flushExecutor();
            LinkedListIterator<MessageReference> iterator = this.queue.totalIterator();
            try {
                while (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    if (filter != null && !filter.match(ref.getMessage())) continue;
                    ServerMessage message = ref.getMessage();
                    messages.add(message.toMap());
                }
                mapArray = messages.toArray(new Map[messages.size()]);
            }
            catch (Throwable throwable) {
                try {
                    iterator.close();
                    throw throwable;
                }
                catch (HornetQException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            iterator.close();
            return mapArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listMessagesAsJSON(String filter) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listMessages(filter));
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstMessageAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string;
            ArrayList<Map> messages = new ArrayList<Map>();
            this.queue.flushExecutor();
            LinkedListIterator<MessageReference> iterator = this.queue.totalIterator();
            try {
                if (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    ServerMessage message = ref.getMessage();
                    messages.add(message.toMap());
                }
                string = QueueControlImpl.toJSON(messages.toArray(new Map[1])).toString();
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            long l;
            Filter filter = FilterImpl.createFilter(filterStr);
            if (filter == null) {
                long l2 = this.getMessageCount();
                return l2;
            }
            LinkedListIterator<MessageReference> iterator = this.queue.totalIterator();
            try {
                int count = 0;
                while (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    if (!filter.match(ref.getMessage())) continue;
                    ++count;
                }
                l = count;
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean removeMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.deleteReference(messageID);
            return bl;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public int removeMessages(String filterStr) throws Exception {
        return this.removeMessages(500, filterStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMessages(int flushLimit, String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.deleteMatchingReferences(flushLimit, filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expireMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.expireReference(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int expireMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.expireReferences(filter);
            return n;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean moveMessage(long messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMessage(long messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw HornetQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            boolean bl = this.queue.moveReference(messageID, binding.getAddress(), rejectDuplicates);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMessages(int flushLimit, String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            int retValue;
            Filter filter = FilterImpl.createFilter(filterStr);
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw HornetQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            int n = retValue = this.queue.moveReferences(flushLimit, filter, binding.getAddress(), rejectDuplicates);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        return this.moveMessages(500, filterStr, otherQueueName, rejectDuplicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.sendMessagesToDeadLetterAddress(filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.sendMessageToDeadLetterAddress(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw HornetQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.changeReferencesPriority(filter, (byte)newPriority);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeMessagePriority(long messageID, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw HornetQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            boolean bl = this.queue.changeReferencePriority(messageID, (byte)newPriority);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterInfo.toJSon(this.counter);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            this.counter.resetCounter();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listMessageCounterAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listMessageCounterHistory() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistory(this.counter);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listMessageCounterHistoryAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistoryAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.pause();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resume();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isPaused();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Collection<Consumer> consumers = this.queue.getConsumers();
            JSONArray jsonArray = new JSONArray();
            for (Consumer consumer : consumers) {
                if (!(consumer instanceof ServerConsumer)) continue;
                ServerConsumer serverConsumer = (ServerConsumer)consumer;
                JSONObject obj = new JSONObject();
                obj.put("consumerID", serverConsumer.getID());
                obj.put("connectionID", (Object)serverConsumer.getConnectionID().toString());
                obj.put("sessionID", (Object)serverConsumer.getSessionID());
                obj.put("browseOnly", serverConsumer.isBrowseOnly());
                obj.put("creationTime", serverConsumer.getCreationTime());
                jsonArray.put((Object)obj);
            }
            String string = jsonArray.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(QueueControl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMessagesAdded() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesAdded();
        }
        finally {
            this.blockOnIO();
        }
    }

    private void checkStarted() {
        if (!this.postOffice.isStarted()) {
            throw new IllegalStateException("HornetQ Server is not started. Queue can not be managed yet");
        }
    }
}

