/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.as.webservices.WSMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

public final class HandlerChainService<T extends AbstractCommonConfig>
implements Service<UnifiedHandlerChainMetaData> {
    private InjectedValue<T> abstractCommonConfig = new InjectedValue();
    private final String handlerChainType;
    private final String handlerChainId;
    private final String protocolBindings;
    private volatile UnifiedHandlerChainMetaData handlerChain;

    public HandlerChainService(String handlerChainType, String handlerChainId, String protocolBindings) {
        this.handlerChainType = handlerChainType;
        this.handlerChainId = handlerChainId;
        this.protocolBindings = protocolBindings;
    }

    public UnifiedHandlerChainMetaData getValue() {
        return this.handlerChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        CopyOnWriteArrayList<Object> handlerChains;
        AbstractCommonConfig commonConfig = (AbstractCommonConfig)this.abstractCommonConfig.getValue();
        if ("pre-handler-chain".equals(this.handlerChainType)) {
            AbstractCommonConfig abstractCommonConfig = commonConfig;
            synchronized (abstractCommonConfig) {
                handlerChains = commonConfig.getPreHandlerChains();
                if (handlerChains == null) {
                    handlerChains = new CopyOnWriteArrayList<UnifiedHandlerChainMetaData>();
                    commonConfig.setPreHandlerChains(handlerChains);
                }
            }
        } else if ("post-handler-chain".equals(this.handlerChainType)) {
            AbstractCommonConfig abstractCommonConfig = commonConfig;
            synchronized (abstractCommonConfig) {
                handlerChains = commonConfig.getPostHandlerChains();
                if (handlerChains == null) {
                    handlerChains = new CopyOnWriteArrayList();
                    commonConfig.setPostHandlerChains(handlerChains);
                }
            }
        } else {
            throw new StartException((Throwable)WSMessages.MESSAGES.wrongHandlerChainType(this.handlerChainType, "pre-handler-chain", "post-handler-chain"));
        }
        this.handlerChain = HandlerChainService.getChain(handlerChains, this.handlerChainId);
        if (this.handlerChain != null) {
            throw new StartException((Throwable)WSMessages.MESSAGES.multipleHandlerChainsWithSameId(this.handlerChainType, this.handlerChainId, commonConfig.getConfigName()));
        }
        this.handlerChain = new UnifiedHandlerChainMetaData();
        this.handlerChain.setId(this.handlerChainId);
        this.handlerChain.setProtocolBindings(this.protocolBindings);
        handlerChains.add(this.handlerChain);
    }

    private static UnifiedHandlerChainMetaData getChain(List<UnifiedHandlerChainMetaData> handlerChains, String handlerChainId) {
        for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
            if (!handlerChainId.equals(handlerChain.getId())) continue;
            return handlerChain;
        }
        return null;
    }

    public void stop(StopContext context) {
        AbstractCommonConfig commonConfig = (AbstractCommonConfig)this.abstractCommonConfig.getValue();
        List handlerChains = "pre-handler-chain".equals(this.handlerChainType) ? commonConfig.getPreHandlerChains() : commonConfig.getPostHandlerChains();
        handlerChains.remove(this.handlerChain);
    }

    public InjectedValue<T> getAbstractCommonConfig() {
        return this.abstractCommonConfig;
    }
}

