/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class DefaultAccessLogReceiver
implements AccessLogReceiver,
Runnable,
Closeable {
    private static final String DEFAULT_LOG_SUFFIX = ".log";
    private final Executor logWriteExecutor;
    private final Deque<String> pendingMessages;
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<DefaultAccessLogReceiver> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultAccessLogReceiver.class, "state");
    private long changeOverPoint;
    private String currentDateString;
    private boolean forceLogRotation;
    private final File outputDirectory;
    private final File defaultLogFile;
    private final String logBaseName;
    private final String logNameSuffix;
    private Writer writer = null;

    public DefaultAccessLogReceiver(Executor logWriteExecutor, File outputDirectory, String logBaseName) {
        this(logWriteExecutor, outputDirectory, logBaseName, null);
    }

    public DefaultAccessLogReceiver(Executor logWriteExecutor, File outputDirectory, String logBaseName, String logNameSuffix) {
        this.logWriteExecutor = logWriteExecutor;
        this.outputDirectory = outputDirectory;
        this.logBaseName = logBaseName;
        this.logNameSuffix = logNameSuffix != null ? logNameSuffix : DEFAULT_LOG_SUFFIX;
        this.pendingMessages = new ConcurrentLinkedDeque<String>();
        this.defaultLogFile = new File(outputDirectory, logBaseName + this.logNameSuffix);
        this.calculateChangeOverPoint();
    }

    private void calculateChangeOverPoint() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 59);
        calendar.set(12, 59);
        calendar.set(10, 23);
        this.changeOverPoint = calendar.getTimeInMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.currentDateString = df.format(new Date());
    }

    @Override
    public void logMessage(String message) {
        this.pendingMessages.add(message);
        int state = stateUpdater.get(this);
        if (state == 0 && stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!stateUpdater.compareAndSet(this, 1, 2)) {
            return;
        }
        if (this.forceLogRotation) {
            this.doRotate();
        }
        ArrayList<String> messages = new ArrayList<String>();
        String msg = null;
        for (int i = 0; i < 1000 && (msg = this.pendingMessages.poll()) != null; ++i) {
            messages.add(msg);
        }
        try {
            if (!messages.isEmpty()) {
                this.writeMessage(messages);
            }
        }
        finally {
            stateUpdater.set(this, 0);
            if ((!this.pendingMessages.isEmpty() || this.forceLogRotation) && stateUpdater.compareAndSet(this, 0, 1)) {
                this.logWriteExecutor.execute(this);
            }
        }
    }

    void awaitWrittenForTest() throws InterruptedException {
        while (!this.pendingMessages.isEmpty() || this.forceLogRotation) {
            Thread.sleep(10L);
        }
        while (this.state != 0) {
            Thread.sleep(10L);
        }
    }

    private void writeMessage(List<String> messages) {
        if (System.currentTimeMillis() > this.changeOverPoint) {
            this.doRotate();
        }
        try {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new FileWriter(this.defaultLogFile));
            }
            for (String message : messages) {
                this.writer.write(message);
                this.writer.write(10);
            }
            this.writer.flush();
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.errorWritingAccessLog(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRotate() {
        this.forceLogRotation = false;
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            File newFile = new File(this.outputDirectory, this.logBaseName + "_" + this.currentDateString + this.logNameSuffix);
            int count = 0;
            while (newFile.exists()) {
                newFile = new File(this.outputDirectory, this.logBaseName + "_" + this.currentDateString + "-" + ++count + this.logNameSuffix);
            }
            if (!this.defaultLogFile.renameTo(newFile)) {
                UndertowLogger.ROOT_LOGGER.errorRotatingAccessLog(new IOException());
            }
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.errorRotatingAccessLog(e);
        }
        finally {
            this.calculateChangeOverPoint();
        }
    }

    public void rotate() {
        this.forceLogRotation = true;
        if (stateUpdater.compareAndSet(this, 0, 1)) {
            this.logWriteExecutor.execute(this);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }
}

