/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.server.protocol.ajp.AbstractAjpParseState;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

public abstract class AbstractAjpParser {
    public static final int STRING_LENGTH_MASK = Integer.MIN_VALUE;

    protected IntegerHolder parse16BitInteger(ByteBuffer buf, AbstractAjpParseState state) {
        if (!buf.hasRemaining()) {
            return new IntegerHolder(-1, false);
        }
        int number = state.currentIntegerPart;
        if (number == -1) {
            number = buf.get() & 0xFF;
        }
        if (buf.hasRemaining()) {
            byte b = buf.get();
            int result = ((0xFF & number) << 8) + (b & 0xFF);
            state.currentIntegerPart = -1;
            return new IntegerHolder(result, true);
        }
        state.currentIntegerPart = number;
        return new IntegerHolder(-1, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected StringHolder parseString(ByteBuffer buf, AbstractAjpParseState state, boolean header) {
        int number;
        boolean containsUrlCharacters = state.containsUrlCharacters;
        if (!buf.hasRemaining()) {
            return new StringHolder(null, false, false);
        }
        int stringLength = state.stringLength;
        if (stringLength == -1) {
            number = buf.get() & 0xFF;
            if (!buf.hasRemaining()) {
                state.stringLength = number | Integer.MIN_VALUE;
                return new StringHolder(null, false, false);
            }
            byte b = buf.get();
            stringLength = ((0xFF & number) << 8) + (b & 0xFF);
        } else if ((stringLength & Integer.MIN_VALUE) != 0) {
            number = stringLength & Integer.MAX_VALUE;
            stringLength = ((0xFF & number) << 8) + (buf.get() & 0xFF);
        }
        if (header && (stringLength & 0xFF00) != 0) {
            state.stringLength = -1;
            return new StringHolder(this.headers(stringLength & 0xFF));
        }
        if (stringLength == 65535) {
            state.stringLength = -1;
            return new StringHolder(null, true, false);
        }
        StringBuilder builder = state.currentString;
        if (builder == null) {
            state.currentString = builder = new StringBuilder();
        }
        for (int length = builder.length(); length < stringLength; ++length) {
            if (!buf.hasRemaining()) {
                state.stringLength = stringLength;
                state.containsUrlCharacters = containsUrlCharacters;
                return new StringHolder(null, false, false);
            }
            char c = (char)buf.get();
            if (c == '+' || c == '%') {
                containsUrlCharacters = true;
            }
            builder.append(c);
        }
        if (buf.hasRemaining()) {
            buf.get();
            state.currentString = null;
            state.stringLength = -1;
            state.containsUrlCharacters = false;
            return new StringHolder(builder.toString(), true, containsUrlCharacters);
        }
        state.stringLength = stringLength;
        state.containsUrlCharacters = containsUrlCharacters;
        return new StringHolder(null, false, false);
    }

    protected abstract HttpString headers(int var1);

    protected static class StringHolder {
        public final String value;
        public final HttpString header;
        public final boolean readComplete;
        public final boolean containsUrlCharacters;

        private StringHolder(String value, boolean readComplete, boolean containsUrlCharacters) {
            this.value = value;
            this.readComplete = readComplete;
            this.containsUrlCharacters = containsUrlCharacters;
            this.header = null;
        }

        private StringHolder(HttpString value) {
            this.value = null;
            this.readComplete = true;
            this.header = value;
            this.containsUrlCharacters = false;
        }
    }

    protected static class IntegerHolder {
        public final int value;
        public final boolean readComplete;

        private IntegerHolder(int value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
        }
    }
}

