/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import org.jboss.as.connector.subsystems.common.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyDefinition;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesExtension;
import org.jboss.as.connector.subsystems.datasources.DisableRequiredWriteAttributeHandler;
import org.jboss.as.connector.subsystems.datasources.XMLDataSourceRuntimeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;

public class DataSourceDefinition
extends SimpleResourceDefinition {
    protected static final PathElement PATH_DATASOURCE = PathElement.pathElement((String)"data-source");
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private DataSourceDefinition(boolean registerRuntimeOnly, boolean deployed) {
        super(PATH_DATASOURCE, (ResourceDescriptionResolver)DataSourcesExtension.getResourceDescriptionResolver("data-source"), (OperationStepHandler)(deployed ? null : DataSourceAdd.INSTANCE), (OperationStepHandler)(deployed ? null : DataSourceRemove.INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("datasources", "data-source");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public static DataSourceDefinition createInstance(boolean registerRuntimeOnly, boolean deployed) {
        return new DataSourceDefinition(registerRuntimeOnly, deployed);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (!this.deployed) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_ENABLE, (OperationStepHandler)DataSourceEnable.LOCAL_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_DISABLE, (OperationStepHandler)DataSourceDisable.LOCAL_INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_IDLE_CONNECTION, (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_ALL_CONNECTION, (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_INVALID_CONNECTION, (OperationStepHandler)PoolOperations.FlushInvalidConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_GRACEFULLY_CONNECTION, (OperationStepHandler)PoolOperations.FlushGracefullyConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.TEST_CONNECTION, (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE);
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            SimpleAttributeDefinition runtimeAttribute;
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_ATTRIBUTE) {
                runtimeAttribute = new SimpleAttributeDefinitionBuilder(simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE);
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_PROPERTIES_ATTRIBUTES) {
                runtimeAttribute = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder((PropertiesAttributeDefinition)simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE);
            }
        } else {
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_ATTRIBUTE) {
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(simpleAttributeDefinition.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                    continue;
                }
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)simpleAttributeDefinition, null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])Constants.DATASOURCE_ATTRIBUTE));
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.DATASOURCE_PROPERTIES_ATTRIBUTES) {
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(simpleAttributeDefinition.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                    continue;
                }
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)simpleAttributeDefinition, null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])Constants.DATASOURCE_PROPERTIES_ATTRIBUTES));
            }
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            resourceRegistration.registerSubModel((ResourceDefinition)ConnectionPropertyDefinition.DEPLOYED_INSTANCE);
        } else {
            resourceRegistration.registerSubModel((ResourceDefinition)ConnectionPropertyDefinition.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    static void registerTransformers110(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)parentBuilder.addChildResource(PATH_DATASOURCE).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])Constants.DATASOURCE_PROPERTIES_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_ADD_TRANSFORMER).end();
        ConnectionPropertyDefinition.registerTransformers11x(builder);
    }

    static void registerTransformers111(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_ADD_TRANSFORMER).end();
        ConnectionPropertyDefinition.registerTransformers11x(builder);
    }
}

