/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheGroupService;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.server.group.CacheNodeFactoryProvider;

public class CacheGroupProvider
implements CacheServiceProvider {
    private static final Logger logger = Logger.getLogger(CacheServiceProvider.class);

    public static ServiceName getServiceName(String containerName, String cacheName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "group", containerName, cacheName});
    }

    private static ContextNames.BindInfo createBinding(String containerName, String cacheName) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "group", containerName, cacheName}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String containerName, String cacheName, boolean defaultCache) {
        return Arrays.asList(CacheGroupProvider.getServiceName(containerName, cacheName), CacheGroupProvider.createBinding(containerName, cacheName).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId) {
        ServiceName name = CacheGroupProvider.getServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = CacheGroupProvider.createBinding(containerName, cacheName);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        CacheGroupConfig config = new CacheGroupConfig();
        CacheGroupService service = new CacheGroupService(config);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, config.getCacheInjector()).addDependency(CacheNodeFactoryProvider.getServiceName(containerName, cacheName), CacheNodeFactory.class, config.getNodeFactoryInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, Group.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (defaultCache) {
            ContextNames.BindInfo info = CacheGroupProvider.createBinding(containerName, "default");
            binderBuilder.addAliases(new ServiceName[]{info.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{info.getBindName()})});
            builder.addAliases(new ServiceName[]{CacheGroupProvider.getServiceName(containerName, "default")});
        }
        return Arrays.asList(builder.install(), binderBuilder.install());
    }

    static class CacheGroupConfig
    implements CacheGroupConfiguration {
        private final InjectedValue<Cache> cache = new InjectedValue();
        private final InjectedValue<CacheNodeFactory> factory = new InjectedValue();

        CacheGroupConfig() {
        }

        @Override
        public Cache<?, ?> getCache() {
            return (Cache)this.cache.getValue();
        }

        @Override
        public CacheNodeFactory getNodeFactory() {
            return (CacheNodeFactory)this.factory.getValue();
        }

        Injector<Cache> getCacheInjector() {
            return this.cache;
        }

        Injector<CacheNodeFactory> getNodeFactoryInjector() {
            return this.factory;
        }
    }
}

