/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAsset
implements Asset {
    private static final char DELIMITER_RESOURCE_PATH = '/';
    private static final char DELIMITER_CLASS_NAME_PATH = '.';
    private static final String EXTENSION_CLASS = ".class";
    private Class<?> clazz;

    public ClassAsset(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be specified");
        }
        this.clazz = clazz;
    }

    @Override
    public InputStream openStream() {
        ClassLoader classLoader = this.clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new ClassLoaderAsset(this.getResourceNameOfClass(this.clazz), classLoader).openStream();
    }

    public Class<?> getSource() {
        return this.clazz;
    }

    private String getResourceNameOfClass(Class<?> clazz) throws IllegalArgumentException {
        String fqn = clazz.getName();
        String nameAsResourcePath = fqn.replace('.', '/');
        String resourceName = nameAsResourcePath + EXTENSION_CLASS;
        return resourceName;
    }
}

