/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;

public class BackupConfiguration {
    private final String site;
    private final BackupStrategy strategy;
    private long timeout;
    private final BackupFailurePolicy backupFailurePolicy;
    private final String failurePolicyClass;
    private final boolean useTwoPhaseCommit;
    private final TakeOfflineConfiguration takeOfflineConfiguration;
    private final XSiteStateTransferConfiguration stateTransferConfiguration;
    private final boolean enabled;

    public BackupConfiguration(String site, BackupStrategy strategy, long timeout, BackupFailurePolicy backupFailurePolicy, String failurePolicyClass, boolean useTwoPhaseCommit, TakeOfflineConfiguration takeOfflineConfiguration, XSiteStateTransferConfiguration stateTransferConfiguration, boolean enabled) {
        this.site = site;
        this.strategy = strategy;
        this.timeout = timeout;
        this.backupFailurePolicy = backupFailurePolicy;
        this.failurePolicyClass = failurePolicyClass;
        this.useTwoPhaseCommit = useTwoPhaseCommit;
        this.takeOfflineConfiguration = takeOfflineConfiguration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.enabled = enabled;
    }

    public String site() {
        return this.site;
    }

    public BackupStrategy strategy() {
        return this.strategy;
    }

    public TakeOfflineConfiguration takeOffline() {
        return this.takeOfflineConfiguration;
    }

    public String failurePolicyClass() {
        return this.failurePolicyClass;
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public long replicationTimeout() {
        return this.timeout;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return this.backupFailurePolicy;
    }

    public boolean isTwoPhaseCommit() {
        return this.useTwoPhaseCommit;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public XSiteStateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupConfiguration)) {
            return false;
        }
        BackupConfiguration that = (BackupConfiguration)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.backupFailurePolicy != that.backupFailurePolicy) {
            return false;
        }
        if (this.failurePolicyClass != null ? !this.failurePolicyClass.equals(that.failurePolicyClass) : that.failurePolicyClass != null) {
            return false;
        }
        if (this.site != null ? !this.site.equals(that.site) : that.site != null) {
            return false;
        }
        if (this.useTwoPhaseCommit != that.useTwoPhaseCommit) {
            return false;
        }
        if (this.strategy != that.strategy) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        return !(this.stateTransferConfiguration != null ? !this.stateTransferConfiguration.equals(that.stateTransferConfiguration) : that.stateTransferConfiguration != null);
    }

    public int hashCode() {
        int result = this.site != null ? this.site.hashCode() : 0;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.backupFailurePolicy != null ? this.backupFailurePolicy.hashCode() : 0);
        result = 31 * result + (this.failurePolicyClass != null ? this.failurePolicyClass.hashCode() : 0);
        result = 31 * result + (this.stateTransferConfiguration != null ? this.stateTransferConfiguration.hashCode() : 0);
        result = 31 * result + (this.useTwoPhaseCommit ? 1 : 0);
        return result;
    }

    public String toString() {
        return "BackupConfiguration{site='" + this.site + '\'' + ", strategy=" + (Object)((Object)this.strategy) + ", timeout=" + this.timeout + ", useTwoPhaseCommit=" + this.useTwoPhaseCommit + ", backupFailurePolicy=" + (Object)((Object)this.backupFailurePolicy) + ", failurePolicyClass='" + this.failurePolicyClass + '\'' + ", stateTransferConfiguration=" + this.stateTransferConfiguration + ", enabled='" + this.enabled + '\'' + '}';
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

