/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.ScopeDetector;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;

public class ComponentMetadataPersister
extends ComponentMetadataRepo {
    private static ComponentMetadataRepo repo;

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        long startTime = System.nanoTime();
        String path = args[0];
        String outputFile = args[1];
        System.out.printf(" [ComponentMetadataPersister] Starting component metadata generation.  Scanning classes in %s%n", path);
        repo = new ComponentMetadataRepo();
        ComponentMetadataPersister.repo.factories.clear();
        ComponentMetadataPersister.repo.componentMetadataMap.clear();
        File f = new File(path);
        ComponentMetadataPersister.process(path, f);
        HashMap<String, String> dependencies = new HashMap<String, String>(128);
        for (ComponentMetadata md : ComponentMetadataPersister.repo.componentMetadataMap.values()) {
            if (md.getDependencies() == null) continue;
            dependencies.putAll(md.getDependencies());
        }
        ClassLoader cl = ComponentMetadataRepo.class.getClassLoader();
        for (String s : dependencies.keySet()) {
            if (ComponentMetadataPersister.repo.componentMetadataMap.containsKey(s)) continue;
            try {
                Class dependencyType = Util.loadClass((String)s, (ClassLoader)cl);
                ComponentMetadata equivalent = null;
                for (ComponentMetadata cm : ComponentMetadataPersister.repo.componentMetadataMap.values()) {
                    if (!dependencyType.isAssignableFrom(cm.getClazz())) continue;
                    equivalent = cm;
                    break;
                }
                if (equivalent == null) continue;
                ComponentMetadataPersister.repo.componentMetadataMap.put(s, equivalent);
            }
            catch (Exception e) {}
        }
        if (Boolean.getBoolean("infinispan.isCoreModule")) {
            boolean hasErrors = false;
            for (Map.Entry e : dependencies.entrySet()) {
                if (ComponentMetadataPersister.repo.componentMetadataMap.containsKey(e.getKey()) || ComponentMetadataPersister.hasFactory((String)e.getKey()) || ComponentMetadataPersister.hasFactory((String)e.getValue()) || KnownComponentNames.ALL_KNOWN_COMPONENT_NAMES.contains(e.getKey())) continue;
                System.out.printf(" [ComponentMetadataPersister]     **** WARNING!!!  Missing components or factories for dependency on %s%n", e.getKey());
                hasErrors = true;
            }
            if (hasErrors && Boolean.getBoolean("infinispan.isCoreModule")) {
                throw new RuntimeException("Could not pass sanity check of all annotated components and their respective factories/dependencies.");
            }
        }
        ComponentMetadataPersister.writeMetadata(outputFile);
        System.out.printf(" [ComponentMetadataPersister] %s components and %s factories analyzed and persisted in %s.%n%n", ComponentMetadataPersister.repo.componentMetadataMap.size(), ComponentMetadataPersister.repo.factories.size(), Util.prettyPrintTime((long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS));
    }

    private static boolean hasFactory(String name) {
        return ComponentMetadataPersister.repo.factories.containsKey(name);
    }

    private static void process(String path, File f) throws ClassNotFoundException {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                ComponentMetadataPersister.process(path, child);
            }
        } else if (ComponentMetadataPersister.isValidClassFile(f)) {
            String fqcn = ComponentMetadataPersister.extractFqcn(path, f);
            ComponentMetadataPersister.processClass(ComponentMetadataRepo.class.getClassLoader().loadClass(fqcn), fqcn);
        }
    }

    private static boolean isValidClassFile(File f) {
        return f.getName().endsWith(".class");
    }

    private static void processClass(Class<?> clazz, String className) {
        DefaultFactoryFor dff;
        MBean mbean = (MBean)ReflectionUtil.getAnnotation(clazz, MBean.class);
        boolean isGlobal = ScopeDetector.detectScope(clazz) == Scopes.GLOBAL;
        boolean survivesRestarts = ReflectionUtil.getAnnotation(clazz, SurvivesRestarts.class) != null;
        List injectMethods = ReflectionUtil.getAllMethods(clazz, Inject.class);
        List startMethods = ReflectionUtil.getAllMethods(clazz, Start.class);
        List stopMethods = ReflectionUtil.getAllMethods(clazz, Stop.class);
        ComponentMetadata metadata = null;
        if (mbean != null) {
            List managedAttributeMethods = ReflectionUtil.getAllMethods(clazz, ManagedAttribute.class);
            List managedAttributeFields = ReflectionUtil.getAnnotatedFields(clazz, ManagedAttribute.class);
            List managedOperationMethods = ReflectionUtil.getAllMethods(clazz, ManagedOperation.class);
            metadata = new ManageableComponentMetadata(clazz, injectMethods, startMethods, stopMethods, isGlobal, survivesRestarts, managedAttributeFields, managedAttributeMethods, managedOperationMethods, mbean);
        } else if (!injectMethods.isEmpty() || !startMethods.isEmpty() || !stopMethods.isEmpty() || isGlobal || survivesRestarts || ReflectionUtil.isAnnotationPresent(clazz, Scope.class)) {
            metadata = new ComponentMetadata(clazz, injectMethods, startMethods, stopMethods, isGlobal, survivesRestarts);
        }
        if (metadata != null) {
            ComponentMetadataPersister.repo.componentMetadataMap.put(metadata.getName(), metadata);
        }
        if ((dff = (DefaultFactoryFor)ReflectionUtil.getAnnotation(clazz, DefaultFactoryFor.class)) != null) {
            for (Class<?> target : dff.classes()) {
                ComponentMetadataPersister.repo.factories.put(target.getName(), className);
            }
        }
    }

    private static String extractFqcn(String path, File f) {
        return f.getAbsolutePath().replace(path, "").replace(File.separator, ".").replaceAll("\\.class$", "").replaceFirst("\\.+", "");
    }

    private static void writeMetadata(String metadataFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(metadataFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        objectOutputStream.writeObject(ComponentMetadataPersister.repo.componentMetadataMap);
        objectOutputStream.writeObject(ComponentMetadataPersister.repo.factories);
        objectOutputStream.flush();
        objectOutputStream.close();
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.printf(" [ComponentMetadataPersister] Persisted metadata in %s%n", metadataFile);
    }
}

