/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.mw.wst11.UserBusinessActivityFactory;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.jboss.narayana.compensations.api.Compensatable;
import org.jboss.narayana.compensations.api.CompensationManager;
import org.jboss.narayana.compensations.api.TransactionCompensatedException;
import org.jboss.narayana.compensations.impl.CompensationManagerImpl;
import org.jboss.narayana.compensations.impl.CompensationManagerState;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;

public class CompensationInterceptorBase {
    @Inject
    CompensationManager compensationManager;
    @Inject
    BeanManager beanManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic) throws Exception {
        this.beginBusinessActivity();
        Object result = null;
        boolean isException = false;
        try {
            result = ic.proceed();
        }
        catch (Exception e) {
            isException = true;
            this.handleException(ic, e, true);
        }
        finally {
            this.completeBusinessActivity(isException);
        }
        return result;
    }

    protected Object invokeInCallerTx(InvocationContext ic) throws Exception {
        Object result = null;
        try {
            result = ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, false);
        }
        return result;
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    private void beginBusinessActivity() throws WrongStateException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().begin();
        CompensationManagerImpl.resume(new CompensationManagerState());
        TXDataMapImpl.resume(new HashMap());
    }

    private void closeBusinessActivity() throws WrongStateException, UnknownTransactionException, TransactionRolledBackException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().close();
        CompensationManagerImpl.suspend();
        TXDataMapImpl.suspend();
    }

    private void cancelBusinessActivity() throws WrongStateException, UnknownTransactionException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().cancel();
        CompensationManagerImpl.suspend();
        TXDataMapImpl.suspend();
    }

    private void completeBusinessActivity(boolean isException) throws WrongStateException, UnknownTransactionException, SystemException {
        if (CompensationManagerImpl.isCompensateOnly() && !isException) {
            this.cancelBusinessActivity();
            throw new TransactionCompensatedException("Transaction was marked as 'compensate only'");
        }
        if (CompensationManagerImpl.isCompensateOnly()) {
            this.cancelBusinessActivity();
        } else {
            try {
                this.closeBusinessActivity();
            }
            catch (TransactionRolledBackException e) {
                throw new TransactionCompensatedException("Failed to close transaction", e);
            }
        }
    }

    private void handleException(InvocationContext ic, Exception exception, boolean started) throws Exception {
        Compensatable compensatable = this.getCompensatable(ic);
        if (this.isDontCancelOn(compensatable, exception)) {
            throw exception;
        }
        if (this.isCancelOn(compensatable, exception) || exception instanceof RuntimeException) {
            this.compensationManager.setCompensateOnly();
        }
        throw exception;
    }

    private boolean isDontCancelOn(Compensatable compensatable, Exception exception) {
        for (Class dontCancelOnClass : compensatable.dontCancelOn()) {
            if (!dontCancelOnClass.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isCancelOn(Compensatable compensatable, Exception exception) {
        for (Class cancelOnClass : compensatable.cancelOn()) {
            if (!cancelOnClass.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    private Compensatable getCompensatable(InvocationContext ic) {
        Compensatable compensatable = ic.getMethod().getAnnotation(Compensatable.class);
        if (compensatable != null) {
            return compensatable;
        }
        Class<?> targetClass = ic.getTarget().getClass();
        compensatable = targetClass.getAnnotation(Compensatable.class);
        if (compensatable != null) {
            return compensatable;
        }
        for (Annotation annotation : ic.getMethod().getDeclaringClass().getAnnotations()) {
            if (!this.beanManager.isStereotype(annotation.annotationType())) continue;
            for (Annotation stereotyped : this.beanManager.getStereotypeDefinition(annotation.annotationType())) {
                if (!stereotyped.annotationType().equals(Compensatable.class)) continue;
                return (Compensatable)stereotyped;
            }
        }
        throw new RuntimeException("Expected an @Compensatable annotation at class and/or method level");
    }
}

