/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermVectorsConsumerPerField;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class TermVectorsConsumer
extends TermsHash {
    TermVectorsWriter writer;
    final BytesRef flushTerm = new BytesRef();
    final DocumentsWriterPerThread docWriter;
    final ByteSliceReader vectorSliceReaderPos = new ByteSliceReader();
    final ByteSliceReader vectorSliceReaderOff = new ByteSliceReader();
    boolean hasVectors;
    int numVectorFields;
    int lastDocID;
    private TermVectorsConsumerPerField[] perFields = new TermVectorsConsumerPerField[1];

    public TermVectorsConsumer(DocumentsWriterPerThread docWriter) {
        super(docWriter, false, null);
        this.docWriter = docWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state) throws IOException {
        if (this.writer != null) {
            int numDocs = state.segmentInfo.getDocCount();
            assert (numDocs > 0);
            try {
                this.fill(numDocs);
                assert (state.segmentInfo != null);
                this.writer.finish(state.fieldInfos, numDocs);
            }
            catch (Throwable throwable) {
                IOUtils.close(this.writer);
                this.writer = null;
                this.lastDocID = 0;
                this.hasVectors = false;
                throw throwable;
            }
            IOUtils.close(this.writer);
            this.writer = null;
            this.lastDocID = 0;
            this.hasVectors = false;
        }
    }

    void fill(int docID) throws IOException {
        while (this.lastDocID < docID) {
            this.writer.startDocument(0);
            this.writer.finishDocument();
            ++this.lastDocID;
        }
    }

    private void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.docWriter.getNumDocsInRAM(), this.docWriter.bytesUsed()));
            this.writer = this.docWriter.codec.termVectorsFormat().vectorsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), context);
            this.lastDocID = 0;
        }
    }

    @Override
    void finishDocument() throws IOException {
        assert (this.docWriter.testPoint("TermVectorsTermsWriter.finishDocument start"));
        if (!this.hasVectors) {
            return;
        }
        ArrayUtil.introSort((Comparable[])this.perFields, (int)0, (int)this.numVectorFields);
        this.initTermVectorsWriter();
        this.fill(this.docState.docID);
        this.writer.startDocument(this.numVectorFields);
        for (int i = 0; i < this.numVectorFields; ++i) {
            this.perFields[i].finishDocument();
        }
        this.writer.finishDocument();
        assert (this.lastDocID == this.docState.docID) : "lastDocID=" + this.lastDocID + " docState.docID=" + this.docState.docID;
        ++this.lastDocID;
        super.reset();
        this.resetFields();
        assert (this.docWriter.testPoint("TermVectorsTermsWriter.finishDocument end"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.hasVectors = false;
        try {
            super.abort();
        }
        finally {
            if (this.writer != null) {
                this.writer.abort();
                this.writer = null;
            }
            this.lastDocID = 0;
            this.reset();
        }
    }

    void resetFields() {
        Arrays.fill(this.perFields, null);
        this.numVectorFields = 0;
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new TermVectorsConsumerPerField(invertState, this, fieldInfo);
    }

    void addFieldToFlush(TermVectorsConsumerPerField fieldToFlush) {
        if (this.numVectorFields == this.perFields.length) {
            int newSize = ArrayUtil.oversize(this.numVectorFields + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            TermVectorsConsumerPerField[] newArray = new TermVectorsConsumerPerField[newSize];
            System.arraycopy(this.perFields, 0, newArray, 0, this.numVectorFields);
            this.perFields = newArray;
        }
        this.perFields[this.numVectorFields++] = fieldToFlush;
    }

    @Override
    void startDocument() {
        this.resetFields();
        this.numVectorFields = 0;
    }
}

