/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class DOMHandler
extends CharactersHandler
implements ParticleHandler {
    private static final Logger log = Logger.getLogger(DOMHandler.class);
    public static final DOMHandler INSTANCE = new DOMHandler();
    private boolean trace = log.isTraceEnabled();

    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (this.trace) {
            log.trace((Object)("startParticle " + elementName + " parent=" + BuilderUtil.toDebugString(parent)));
        }
        Element element = null;
        element = parent == null || !(parent instanceof Element) ? this.createTopElement(elementName.getNamespaceURI(), elementName.getLocalPart()) : this.appendChildElement((Element)parent, elementName.getNamespaceURI(), elementName.getLocalPart());
        this.addAttributes(element, attrs);
        return element;
    }

    public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
        if (this.trace) {
            log.trace((Object)("endParticle " + elementName + " result=" + BuilderUtil.toDebugString(o)));
        }
        return o;
    }

    public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (this.trace) {
            log.trace((Object)("setParent " + elementName + " parent=" + BuilderUtil.toDebugString(parent) + " o=" + BuilderUtil.toDebugString(o)));
        }
    }

    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
        this.setText(owner, value, qName);
    }

    public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
        return value;
    }

    public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData) {
        return null;
    }

    public Element createTopElement(String namespace, String name) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document document = impl.createDocument(null, null, null);
            Element element = document.createElementNS(namespace, name);
            document.appendChild(element);
            if (this.trace) {
                log.trace((Object)("createTopElement " + namespace + ":" + name + " result=" + BuilderUtil.toDebugString(element)));
            }
            return element;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating dom", e);
        }
    }

    public Element appendChildElement(Element parentElement, String namespace, String name) {
        Document document = parentElement.getOwnerDocument();
        Element element = document.createElementNS(namespace, name);
        parentElement.appendChild(element);
        if (this.trace) {
            log.trace((Object)("appendChild parent=" + BuilderUtil.toDebugString(parentElement) + " child=" + BuilderUtil.toDebugString(element)));
        }
        return element;
    }

    public void addAttributes(Element element, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String local = attrs.getLocalName(i);
            String nsURI = attrs.getURI(i);
            String value = attrs.getValue(i);
            if (this.trace) {
                log.trace((Object)("setAttribute " + nsURI + " " + local + " element=" + BuilderUtil.toDebugString(element) + " value=" + value));
            }
            element.setAttributeNS(nsURI, local, value);
        }
    }

    public void setText(Object owner, Object value, QName qName) {
        if (value == null) {
            return;
        }
        if (owner == null || !(owner instanceof Element)) {
            throw new IllegalStateException("Unexpected owner: " + owner + " for " + qName);
        }
        if (!(value instanceof String)) {
            throw new IllegalStateException("Unexpected value " + value + " for " + qName);
        }
        Element element = (Element)owner;
        Text text = element.getOwnerDocument().createTextNode((String)value);
        if (this.trace) {
            log.trace((Object)("setText " + qName + " parent=" + BuilderUtil.toDebugString(owner) + " child=" + BuilderUtil.toDebugString(value)));
        }
        element.appendChild(text);
    }
}

