/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.util.jar.JarFile;
import org.jboss.modules.JarModuleFinder;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class JarModuleLoader
extends ModuleLoader {
    static final String[] NO_STRINGS = new String[0];
    private final ModuleLoader delegate;
    private final JarFile jarFile;
    private final ModuleIdentifier myIdentifier;

    JarModuleLoader(ModuleLoader delegate, JarFile jarFile) {
        super(new ModuleFinder[]{new JarModuleFinder(JarModuleLoader.simpleNameOf(jarFile), jarFile)});
        this.delegate = delegate;
        this.jarFile = jarFile;
        this.myIdentifier = JarModuleLoader.simpleNameOf(jarFile);
    }

    private static ModuleIdentifier simpleNameOf(JarFile jarFile) {
        String jarName = jarFile.getName();
        String simpleJarName = jarName.substring(jarName.lastIndexOf(File.separatorChar) + 1);
        return ModuleIdentifier.create(simpleJarName);
    }

    @Override
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.equals(this.myIdentifier)) {
            return this.loadModuleLocal(identifier);
        }
        Module module = this.loadModuleLocal(identifier);
        if (module == null) {
            return JarModuleLoader.preloadModule(identifier, this.delegate);
        }
        return module;
    }

    ModuleIdentifier getMyIdentifier() {
        return this.myIdentifier;
    }

    @Override
    public String toString() {
        return "JAR module loader";
    }
}

