/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.CurrentEjbClientConnection;
import org.jboss.naming.remote.client.RemoteContextFactory;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.client.RemoteNamingStoreConnectionInfo;
import org.jboss.naming.remote.client.ejb.EJBClientHandler;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.naming.remote.protocol.NamingIOException;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class HaRemoteNamingStore
implements RemoteNamingStore {
    private static final Logger logger = Logger.getLogger(HaRemoteNamingStore.class);
    private final List<RemoteNamingStoreConnectionInfo> namingStoreConnections;
    private volatile boolean closed = false;
    private volatile int nextServer;
    private volatile RemoteNamingStore currentNamingStore;
    private final EJBClientHandler ejbClientHandler;
    private Connection connection;

    public HaRemoteNamingStore(long channelCreationTimeoutInMillis, OptionMap channelCreationOptions, long connectionTimeout, CallbackHandler callbackHandler, OptionMap connectOptions, List<URI> connectionURIs, Endpoint clientEndpoint, boolean randomServer) {
        this(channelCreationTimeoutInMillis, channelCreationOptions, connectionTimeout, callbackHandler, connectOptions, connectionURIs, clientEndpoint, randomServer, null);
    }

    HaRemoteNamingStore(long channelCreationTimeoutInMillis, OptionMap channelCreationOptions, long connectionTimeout, CallbackHandler callbackHandler, OptionMap connectOptions, List<URI> connectionURIs, Endpoint clientEndpoint, boolean randomServer, EJBClientHandler ejbClientHandler) {
        if (connectionURIs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a HA remote naming store without any servers to connect to");
        }
        this.namingStoreConnections = new ArrayList<RemoteNamingStoreConnectionInfo>(connectionURIs.size());
        for (int i = 0; i < connectionURIs.size(); ++i) {
            RemoteNamingStoreConnectionInfo connectionInfo = new RemoteNamingStoreConnectionInfo(clientEndpoint, connectionURIs.get(i), connectOptions, connectionTimeout, callbackHandler, channelCreationTimeoutInMillis, channelCreationOptions);
            this.namingStoreConnections.add(connectionInfo);
        }
        this.nextServer = randomServer ? new Random().nextInt(this.namingStoreConnections.size()) : 0;
        this.ejbClientHandler = ejbClientHandler;
    }

    public HaRemoteNamingStore(List<RemoteNamingStoreConnectionInfo> namingStoreConnections, boolean randomServer) {
        if (namingStoreConnections == null || namingStoreConnections.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a HA remote naming store without any servers to connect to");
        }
        this.namingStoreConnections = Collections.unmodifiableList(namingStoreConnections);
        this.nextServer = randomServer ? new Random().nextInt(namingStoreConnections.size()) : 0;
        this.ejbClientHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T namingOperation(Operation<T> operation) throws NamingException {
        if (this.closed) {
            throw new NamingException("NamingStore has been closed");
        }
        RemoteNamingStore namingStore = this.namingStore();
        try {
            return operation.operation(namingStore);
        }
        catch (NamingIOException e) {
            HaRemoteNamingStore haRemoteNamingStore = this;
            synchronized (haRemoteNamingStore) {
                namingStore = this.failOverSequence(namingStore);
            }
            return operation.operation(namingStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteNamingStore namingStore() throws NamingException {
        RemoteNamingStore namingStore = this.currentNamingStore;
        if (namingStore == null) {
            HaRemoteNamingStore haRemoteNamingStore = this;
            synchronized (haRemoteNamingStore) {
                if (this.currentNamingStore == null) {
                    return this.failOverSequence(null);
                }
                return this.currentNamingStore;
            }
        }
        return namingStore;
    }

    private RemoteNamingStore failOverSequence(RemoteNamingStore attempted) throws NamingException {
        int startingNext;
        assert (Thread.holdsLock(this));
        RemoteNamingStore currentNamingStore = this.currentNamingStore;
        if (attempted != null && attempted != currentNamingStore) {
            return currentNamingStore;
        }
        if (currentNamingStore != null) {
            try {
                currentNamingStore.close();
                this.connection.close();
            }
            catch (Exception e) {
                logger.debug((Object)"Failed to close existing naming store on failover", (Throwable)e);
            }
        }
        int currentServer = startingNext = this.nextServer();
        RemoteNamingStore store = null;
        ArrayList<String> attemptedConnectionURIs = new ArrayList<String>();
        Exception primaryException = null;
        while (true) {
            RemoteNamingStoreConnectionInfo connectionInfo = this.namingStoreConnections.get(currentServer);
            URI connectionUri = connectionInfo.getConnectionURI();
            Connection connection = null;
            try {
                Endpoint clientEndpoint = connectionInfo.getEndpoint();
                IoFuture futureConnection = clientEndpoint.connect(connectionUri, connectionInfo.getConnectionOptions(), connectionInfo.getCallbackHandler());
                connection = (Connection)IoFutureHelper.get(futureConnection, connectionInfo.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                IoFuture futureChannel = connection.openChannel("naming", connectionInfo.getChannelCreationOptions());
                Channel channel = (Channel)IoFutureHelper.get(futureChannel, connectionInfo.getChannelCreationTimeout(), TimeUnit.MILLISECONDS);
                store = RemoteContextFactory.createVersionedStore(channel, this.ejbClientHandler);
                this.connection = connection;
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to connect to server " + connectionUri), (Throwable)e);
                if (e instanceof SaslException) {
                    primaryException = e;
                } else if (e instanceof ConnectException && primaryException == null && !(primaryException instanceof AuthenticationException)) {
                    primaryException = e;
                }
                if (connectionUri == null) {
                    attemptedConnectionURIs.add("null (" + e.getMessage() + ")");
                } else {
                    attemptedConnectionURIs.add(connectionUri.toString() + " (" + e.getMessage() + ")");
                }
                currentServer = this.nextServer();
                if (connection == null) continue;
                try {
                    connection.close();
                    continue;
                }
                catch (IOException e1) {
                    logger.debug((Object)("Failed to close connection " + connectionUri), (Throwable)e);
                }
                if (currentServer != startingNext) continue;
            }
            break;
        }
        if (store == null) {
            if (primaryException != null) {
                NamingException ne = primaryException instanceof SaslException ? new AuthenticationException("Failed to connect to any server. Servers tried: " + attemptedConnectionURIs) : new CommunicationException("Failed to connect to any server. Servers tried: " + attemptedConnectionURIs);
                ne.initCause(primaryException);
                throw ne;
            }
            throw new CommunicationException("Failed to connect to any server. Servers tried: " + attemptedConnectionURIs);
        }
        this.currentNamingStore = store;
        if (this.ejbClientHandler != null) {
            try {
                this.ejbClientHandler.associate(this.connection);
            }
            catch (Exception e) {
                logger.warn((Object)("Could not associate connection " + this.connection + " with EJB client context"), (Throwable)e);
            }
        }
        return store;
    }

    private int nextServer() {
        assert (Thread.holdsLock(this));
        int next = this.nextServer;
        int newValue = next + 1;
        this.nextServer = newValue == this.namingStoreConnections.size() ? 0 : newValue;
        return next;
    }

    @Override
    public Object lookup(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Object>(){

            @Override
            public Object operation(RemoteNamingStore store) throws NamingException {
                return store.lookup(name);
            }
        });
    }

    @Override
    public void bind(final Name name, final Object object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.bind(name, object);
                return null;
            }
        });
    }

    @Override
    public void rebind(final Name name, final Object object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.rebind(name, object);
                return null;
            }
        });
    }

    @Override
    public void rename(final Name name, final Name object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.rename(name, object);
                return null;
            }
        });
    }

    @Override
    public List<NameClassPair> list(final Name name) throws NamingException {
        return this.namingOperation(new Operation<List<NameClassPair>>(){

            @Override
            public List<NameClassPair> operation(RemoteNamingStore store) throws NamingException {
                return store.list(name);
            }
        });
    }

    @Override
    public List<Binding> listBindings(final Name name) throws NamingException {
        return this.namingOperation(new Operation<List<Binding>>(){

            @Override
            public List<Binding> operation(RemoteNamingStore store) throws NamingException {
                return store.listBindings(name);
            }
        });
    }

    @Override
    public void unbind(final Name name) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.unbind(name);
                return null;
            }
        });
    }

    @Override
    public Context createSubcontext(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Context>(){

            @Override
            public Context operation(RemoteNamingStore store) throws NamingException {
                return store.createSubcontext(name);
            }
        });
    }

    @Override
    public void destroySubcontext(final Name name) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.destroySubcontext(name);
                return null;
            }
        });
    }

    @Override
    public Object lookupLink(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Object>(){

            @Override
            public Object operation(RemoteNamingStore store) throws NamingException {
                return store.lookupLink(name);
            }
        });
    }

    @Override
    public synchronized void close() throws NamingException {
        this.closed = true;
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            NamingException exception = new NamingException("Failed to close connection");
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public void closeAsync() {
        this.closed = true;
        if (this.connection != null) {
            this.connection.closeAsync();
        }
    }

    @Override
    public synchronized void addEjbContext(CurrentEjbClientConnection connection) {
    }

    @Override
    public synchronized void removeEjbContext(CurrentEjbClientConnection connection) {
    }

    private static interface Operation<T> {
        public T operation(RemoteNamingStore var1) throws NamingException;
    }
}

