/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.server.core.ServerConstants;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.ExtendedByteBuf$;
import org.infinispan.server.hotrod.AbstractVersionedDecoder;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.HotRodException;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.RequestParameters;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.logging.Log$class;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001B\u0001\u0003\u0001-\u0011!cQ1dQ\u0016$UmY8eK\u000e{g\u000e^3yi*\u00111\u0001B\u0001\u0007Q>$(o\u001c3\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005Q\u0011N\u001c4j]&\u001c\b/\u00198\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0007\u00131A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\t\r|'/Z\u0005\u0003/Q\u0011qbU3sm\u0016\u00148i\u001c8ti\u0006tGo\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\t\tq\u0001\\8hO&tw-\u0003\u0002\u001e5\t\u0019Aj\\4\t\u0011\u0015\u0001!\u0011!Q\u0001\n}\u0001\"\u0001I\u0011\u000e\u0003\tI!A\t\u0002\u0003\u0019!{GOU8e'\u0016\u0014h/\u001a:\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002!\u0001!)Qa\ta\u0001?\u0015!\u0011\u0006\u0001\u0001+\u00055\u0011\u0015\u0010^3t%\u0016\u001c\bo\u001c8tKB!QbK\u00175\u0013\tacBA\u0005Gk:\u001cG/[8ocA\u0011a&\r\b\u0003A=J!\u0001\r\u0002\u0002\u000fA\f7m[1hK&\u0011!g\r\u0002\u0006\u0005f$Xm\u001d\u0006\u0003a\t\u0001\"\u0001I\u001b\n\u0005Y\u0012!\u0001\u0003*fgB|gn]3\t\u000fa\u0002!\u0019!C\u0001s\u00059\u0011n\u001d+sC\u000e,W#\u0001\u001e\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\u001d\u0011un\u001c7fC:DaA\u0010\u0001!\u0002\u0013Q\u0014\u0001C5t)J\f7-\u001a\u0011\t\u000f\u0001\u0003!\u0019!C\u0001\u0003\u0006y1+Z2p]\u0012\u001c\u0018J\\!N_:$\b.F\u0001C!\ti1)\u0003\u0002E\u001d\t\u0019\u0011J\u001c;\t\r\u0019\u0003\u0001\u0015!\u0003C\u0003A\u0019VmY8oINLe.Q'p]RD\u0007\u0005C\u0004I\u0001\u0001\u0007I\u0011A\u001d\u0002\u000f%\u001cXI\u001d:pe\"9!\n\u0001a\u0001\n\u0003Y\u0015aC5t\u000bJ\u0014xN]0%KF$\"\u0001T(\u0011\u00055i\u0015B\u0001(\u000f\u0005\u0011)f.\u001b;\t\u000fAK\u0015\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\t\rI\u0003\u0001\u0015)\u0003;\u0003!I7/\u0012:s_J\u0004\u0003\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0001V\u0003\u001d!WmY8eKJ,\u0012A\u0016\t\u0003A]K!\u0001\u0017\u0002\u00031\u0005\u00137\u000f\u001e:bGR4VM]:j_:,G\rR3d_\u0012,'\u000fC\u0005[\u0001\u0001\u0007\t\u0019!C\u00017\u0006YA-Z2pI\u0016\u0014x\fJ3r)\taE\fC\u0004Q3\u0006\u0005\t\u0019\u0001,\t\ry\u0003\u0001\u0015)\u0003W\u0003!!WmY8eKJ\u0004\u0003\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0001b\u0003\u0019AW-\u00193feV\t!\r\u0005\u0002!G&\u0011AM\u0001\u0002\r\u0011>$(k\u001c3IK\u0006$WM\u001d\u0005\nM\u0002\u0001\r\u00111A\u0005\u0002\u001d\f!\u0002[3bI\u0016\u0014x\fJ3r)\ta\u0005\u000eC\u0004QK\u0006\u0005\t\u0019\u00012\t\r)\u0004\u0001\u0015)\u0003c\u0003\u001dAW-\u00193fe\u0002B\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011A7\u0002\u000b\r\f7\r[3\u0016\u00039\u0004Ba\u001c9.[5\ta!\u0003\u0002r\r\ti\u0011\t\u001a<b]\u000e,GmQ1dQ\u0016D\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001;\u0002\u0013\r\f7\r[3`I\u0015\fHC\u0001'v\u0011\u001d\u0001&/!AA\u00029Daa\u001e\u0001!B\u0013q\u0017AB2bG\",\u0007\u0005C\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\u0006\u0019B-\u001a4bk2$H*\u001b4fgB\fg\u000eV5nKV\t1\u0010\u0005\u0002\u000ey&\u0011QP\u0004\u0002\u0005\u0019>tw\r\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003\tq\u0003Z3gCVdG\u000fT5gKN\u0004\u0018M\u001c+j[\u0016|F%Z9\u0015\u00071\u000b\u0019\u0001C\u0004Q}\u0006\u0005\t\u0019A>\t\u000f\u0005\u001d\u0001\u0001)Q\u0005w\u0006!B-\u001a4bk2$H*\u001b4fgB\fg\u000eV5nK\u0002B!\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001{\u0003I!WMZ1vYRl\u0015\r_%eY\u0016$\u0016.\\3\t\u0017\u0005=\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011C\u0001\u0017I\u00164\u0017-\u001e7u\u001b\u0006D\u0018\n\u001a7f)&lWm\u0018\u0013fcR\u0019A*a\u0005\t\u0011A\u000bi!!AA\u0002mDq!a\u0006\u0001A\u0003&10A\neK\u001a\fW\u000f\u001c;NCbLE\r\\3US6,\u0007\u0005C\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0011aA6fsV\tQ\u0006C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0012aB6fs~#S-\u001d\u000b\u0004\u0019\u0006\u0015\u0002\u0002\u0003)\u0002 \u0005\u0005\t\u0019A\u0017\t\u000f\u0005%\u0002\u0001)Q\u0005[\u0005!1.Z=!\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%\t!!\b\u0002\u0011I\fwOV1mk\u0016D1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00024\u0005a!/Y<WC2,Xm\u0018\u0013fcR\u0019A*!\u000e\t\u0011A\u000by#!AA\u00025Bq!!\u000f\u0001A\u0003&Q&A\u0005sC^4\u0016\r\\;fA!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011AA \u0003\u0019\u0001\u0018M]1ngV\u0011\u0011\u0011\t\t\u0004A\u0005\r\u0013bAA#\u0005\t\t\"+Z9vKN$\b+\u0019:b[\u0016$XM]:\t\u0017\u0005%\u0003\u00011AA\u0002\u0013\u0005\u00111J\u0001\u000ba\u0006\u0014\u0018-\\:`I\u0015\fHc\u0001'\u0002N!I\u0001+a\u0012\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\t\u0003#\u0002\u0001\u0015)\u0003\u0002B\u00059\u0001/\u0019:b[N\u0004\u0003bBA+\u0001\u0011\u0005\u0011qK\u0001\fe\u0016\u001cX\r\u001e)be\u0006l7\u000fF\u0001M\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n1c\u0019:fCR,WI\u001d:peJ+7\u000f]8og\u0016$2\u0001DA0\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014!\u0001;\u0011\t\u0005\u0015\u00141\u000f\b\u0005\u0003O\n\tH\u0004\u0003\u0002j\u0005=TBAA6\u0015\r\tiGC\u0001\u0007yI|w\u000e\u001e \n\u0003=I!\u0001\r\b\n\t\u0005U\u0014q\u000f\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\r\b\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u000593M]3bi\u0016,%O]8s%\u0016\u001c\bo\u001c8tK\n+gm\u001c:f%\u0016\fG-\u001b8h%\u0016\fX/Z:u)\u0011\ty(!\"\u0011\u0007\u0001\n\t)C\u0002\u0002\u0004\n\u0011Q\"\u0012:s_J\u0014Vm\u001d9p]N,\u0007\u0002CA1\u0003s\u0002\r!a\u0019\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\u0006)2M]3bi\u0016\u001cVM\u001d<fe\u0016C8-\u001a9uS>tGCBAG\u00033\u000b\u0019\u000b\u0005\u0004\u000e\u0003\u001f\u000b\u0019JO\u0005\u0004\u0003#s!A\u0002+va2,'\u0007E\u0002!\u0003+K1!a&\u0003\u0005=Au\u000e\u001e*pI\u0016C8-\u001a9uS>t\u0007\u0002CAN\u0003\u000f\u0003\r!!(\u0002\u0003\u0015\u0004B!!\u001a\u0002 &!\u0011\u0011UA<\u0005%)\u0005pY3qi&|g\u000e\u0003\u0005\u0002&\u0006\u001d\u0005\u0019AAT\u0003\u0005\u0011\u0007\u0003BAU\u0003ok!!a+\u000b\t\u00055\u0016qV\u0001\u0007EV4g-\u001a:\u000b\t\u0005E\u00161W\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u0003k\u000b!![8\n\t\u0005e\u00161\u0016\u0002\b\u0005f$XMQ;g\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000bq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0007\u0003\u0003\fi-!8\u0015\u00071\u000b\u0019\rC\u0005\u0002F\u0006mF\u00111\u0001\u0002H\u0006A\u0001o\\:u\u0007\u0006dG\u000e\u0005\u0003\u000e\u0003\u0013d\u0015bAAf\u001d\tAAHY=oC6,g\b\u0003\u0005\u0002P\u0006m\u0006\u0019AAi\u0003\r\u0019G\u000f\u001f\t\u0005\u0003'\fI.\u0004\u0002\u0002V*!\u0011q[AX\u0003\u001d\u0019\u0007.\u00198oK2LA!a7\u0002V\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\u0002CAp\u0003w\u0003\r!a\u0019\u0002\u000b\r\fWo]3\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u00069!/\u001a9mC\u000e,W#\u0001\u001b\t\u000f\u0005%\b\u0001\"\u0001\u0002l\u0006YqN\u0019;bS:\u001c\u0015m\u00195f)\ra\u0015Q\u001e\u0005\t\u0003_\f9\u000f1\u0001\u0002r\u0006a1-Y2iK6\u000bg.Y4feB!\u00111_A}\u001b\t\t)PC\u0002\u0002x\u001a\tq!\\1oC\u001e,'/\u0003\u0003\u0002|\u0006U(\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\u0002\u001b\t,\u0018\u000e\u001c3NKR\fG-\u0019;b+\t\u0011\u0019\u0001\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\r\u0011IAB\u0001\t[\u0016$\u0018\rZ1uC&!!Q\u0002B\u0004\u0005!iU\r^1eCR\f\u0007b\u0002B\t\u0001\u0011\u0005!1C\u0001\u0004O\u0016$Hc\u0001\u001b\u0003\u0016!9!q\u0003B\b\u0001\u0004i\u0013\u0001C6fs\nKH/Z:\t\u000f\tm\u0001\u0001\"\u0001\u0002f\u0006\u0019\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\"9!q\u0004\u0001\u0005\u0002\u0005\u0015\u0018a\u00039vi&3\u0017IY:f]RDqAa\t\u0001\t\u0003\t)/A\u0002qkRDqAa\n\u0001\t\u0003\u0011I#A\bhK:,'/\u0019;f-\u0016\u00148/[8o)\u0019\u0011YCa\u000f\u0003LA!!Q\u0006B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012A\u0003<feNLwN\\5oO*\u0019!Q\u0007\u0004\u0002\u0013\r|g\u000e^1j]\u0016\u0014\u0018\u0002\u0002B\u001d\u0005_\u0011A\"\u00128uef4VM]:j_:D\u0001B!\u0010\u0003&\u0001\u0007!qH\u0001\te\u0016<\u0017n\u001d;ssB!!\u0011\tB$\u001b\t\u0011\u0019EC\u0002\u0003F\u0019\t\u0011BZ1di>\u0014\u0018.Z:\n\t\t%#1\t\u0002\u0012\u0007>l\u0007o\u001c8f]R\u0014VmZ5tiJL\bb\u00027\u0003&\u0001\u0007!Q\n\t\u0006_\n=S&L\u0005\u0004\u0005#2!!B\"bG\",\u0007b\u0002B+\u0001\u0011\u0005\u0011Q]\u0001\u0007e\u0016lwN^3\t\u000f\te\u0003\u0001\"\u0001\u0003\\\u0005Y1/^2dKN\u001c(+Z:q)\r!$Q\f\u0005\b\u0005?\u00129\u00061\u0001.\u0003\u0011\u0001(/\u001a<\t\u000f\t\r\u0004\u0001\"\u0001\u0003f\u0005yan\u001c;Fq\u0016\u001cW\u000f^3e%\u0016\u001c\b\u000fF\u00025\u0005OBqAa\u0018\u0003b\u0001\u0007Q\u0006C\u0004\u0003l\u0001!\t!!:\u0002\u00199|G/\u0012=jgR\u0014Vm\u001d9\t\u000f\t=\u0004\u0001\"\u0001\u0003r\u0005\t2M]3bi\u0016<U\r\u001e*fgB|gn]3\u0015\u0007Q\u0012\u0019\b\u0003\u0005\u0003v\t5\u0004\u0019\u0001B<\u0003\u0015)g\u000e\u001e:z!\u0019\u0011IHa .[5\u0011!1\u0010\u0006\u0005\u0005{\u0012\u0019$A\u0004f]R\u0014\u0018.Z:\n\t\t\u0005%1\u0010\u0002\u000b\u0007\u0006\u001c\u0007.Z#oiJL\bb\u0002BC\u0001\u0011\u0005!qQ\u0001\u0017GJ,\u0017\r^3Nk2$\u0018nR3u%\u0016\u001c\bo\u001c8tKR\u0019AB!#\t\u0011\t-%1\u0011a\u0001\u0005\u001b\u000bQ\u0001]1jeN\u0004rAa$\u0003\u00166\u00129HD\u0002\u000e\u0005#K1Aa%\u000f\u0003\u0019\u0001&/\u001a3fM&!!q\u0013BM\u0005\ri\u0015\r\u001d\u0006\u0004\u0005's\u0001b\u0002BO\u0001\u0011E!qT\u0001\ti>l\u0015\u000e\u001c7jgR\u00191P!)\t\u000f\t\r&1\u0014a\u0001\u0005\u0006AA.\u001b4fgB\fg\u000e")
public class CacheDecodeContext
implements ServerConstants,
Log {
    private final HotRodServer server;
    private final boolean isTrace;
    private final int SecondsInAMonth;
    private boolean isError;
    private AbstractVersionedDecoder decoder;
    private HotRodHeader header;
    private AdvancedCache<byte[], byte[]> cache;
    private long defaultLifespanTime;
    private long defaultMaxIdleTime;
    private byte[] key;
    private byte[] rawValue;
    private RequestParameters params;
    private final JavaLog log;
    private volatile boolean org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged;
    private volatile boolean org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged;
    private final org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log;
    private final int EXPIRATION_NONE;
    private final int EXPIRATION_DEFAULT;
    private final Subject ANONYMOUS;
    private volatile byte bitmap$0;

    private JavaLog log$lzycompute() {
        CacheDecodeContext cacheDecodeContext = this;
        synchronized (cacheDecodeContext) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.log;
        }
    }

    @Override
    public JavaLog log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public boolean org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged() {
        return this.org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged;
    }

    @Override
    public void org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged_$eq(boolean x$1) {
        this.org$infinispan$server$hotrod$logging$Log$$warnConditionalLogged = x$1;
    }

    @Override
    public boolean org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged() {
        return this.org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged;
    }

    @Override
    public void org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged_$eq(boolean x$1) {
        this.org$infinispan$server$hotrod$logging$Log$$warnForceReturnPreviousLogged = x$1;
    }

    @Override
    public void logViewNullWhileDetectingCrashedMember() {
        Log$class.logViewNullWhileDetectingCrashedMember(this);
    }

    @Override
    public void logUnableToUpdateView() {
        Log$class.logUnableToUpdateView(this);
    }

    @Override
    public void logErrorDetectingCrashedMember(Throwable t) {
        Log$class.logErrorDetectingCrashedMember(this, t);
    }

    @Override
    public IllegalStateException unexpectedEvent(Event<?, ?> e) {
        return Log$class.unexpectedEvent(this, e);
    }

    @Override
    public void warnConditionalOperationNonTransactional(String op) {
        Log$class.warnConditionalOperationNonTransactional(this, op);
    }

    @Override
    public void warnForceReturnPreviousNonTransactional(String op) {
        Log$class.warnForceReturnPreviousNonTransactional(this, op);
    }

    @Override
    public void warnMarshallerAlreadySet(Marshaller existingMarshaller, Marshaller newMarshaller) {
        Log$class.warnMarshallerAlreadySet(this, existingMarshaller, newMarshaller);
    }

    private org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        CacheDecodeContext cacheDecodeContext = this;
        synchronized (cacheDecodeContext) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log.class.org$infinispan$server$core$logging$Log$$log((org.infinispan.server.core.logging.Log)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    public org.infinispan.server.core.logging.JavaLog org$infinispan$server$core$logging$Log$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$infinispan$server$core$logging$Log$$log$lzycompute() : this.org$infinispan$server$core$logging$Log$$log;
    }

    public void info(Function0<String> msg) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void info(Function0<String> msg, Object param1) {
        Log.class.info((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void error(Function0<String> msg, Throwable t) {
        Log.class.error((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void warn(Function0<String> msg, Throwable t) {
        Log.class.warn((org.infinispan.server.core.logging.Log)this, msg, (Throwable)t);
    }

    public void debug(Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void debug(Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void debug(Throwable t, Function0<String> msg) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg);
    }

    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, (Throwable)t, msg, (Object)param1);
    }

    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log.class.debug((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log.class.debugf((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public void trace(Function0<String> msg) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg);
    }

    public void trace(Function0<String> msg, Object param1) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1);
    }

    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2);
    }

    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log.class.trace((org.infinispan.server.core.logging.Log)this, msg, (Object)param1, (Object)param2, (Object)param3);
    }

    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log.class.tracef((org.infinispan.server.core.logging.Log)this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Log.class.isDebugEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public boolean isTraceEnabled() {
        return Log.class.isTraceEnabled((org.infinispan.server.core.logging.Log)this);
    }

    public void logStartWithArgs(String args) {
        Log.class.logStartWithArgs((org.infinispan.server.core.logging.Log)this, (String)args);
    }

    public void logPostingShutdownRequest() {
        Log.class.logPostingShutdownRequest((org.infinispan.server.core.logging.Log)this);
    }

    public void logExceptionReported(Throwable t) {
        Log.class.logExceptionReported((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public void logServerDidNotUnbind() {
        Log.class.logServerDidNotUnbind((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log.class.logChannelStillBound((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logServerDidNotClose() {
        Log.class.logServerDidNotClose((org.infinispan.server.core.logging.Log)this);
    }

    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log.class.logChannelStillConnected((org.infinispan.server.core.logging.Log)this, (Channel)ch, (SocketAddress)address);
    }

    public void logSettingMasterThreadsNotSupported() {
        Log.class.logSettingMasterThreadsNotSupported((org.infinispan.server.core.logging.Log)this);
    }

    public void logErrorBeforeReadingRequest(Throwable t) {
        Log.class.logErrorBeforeReadingRequest((org.infinispan.server.core.logging.Log)this, (Throwable)t);
    }

    public int EXPIRATION_NONE() {
        return this.EXPIRATION_NONE;
    }

    public int EXPIRATION_DEFAULT() {
        return this.EXPIRATION_DEFAULT;
    }

    public Subject ANONYMOUS() {
        return this.ANONYMOUS;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_NONE_$eq(int x$1) {
        this.EXPIRATION_NONE = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$EXPIRATION_DEFAULT_$eq(int x$1) {
        this.EXPIRATION_DEFAULT = x$1;
    }

    public void org$infinispan$server$core$ServerConstants$_setter_$ANONYMOUS_$eq(Subject x$1) {
        this.ANONYMOUS = x$1;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public int SecondsInAMonth() {
        return this.SecondsInAMonth;
    }

    public boolean isError() {
        return this.isError;
    }

    public void isError_$eq(boolean x$1) {
        this.isError = x$1;
    }

    public AbstractVersionedDecoder decoder() {
        return this.decoder;
    }

    public void decoder_$eq(AbstractVersionedDecoder x$1) {
        this.decoder = x$1;
    }

    public HotRodHeader header() {
        return this.header;
    }

    public void header_$eq(HotRodHeader x$1) {
        this.header = x$1;
    }

    public AdvancedCache<byte[], byte[]> cache() {
        return this.cache;
    }

    public void cache_$eq(AdvancedCache<byte[], byte[]> x$1) {
        this.cache = x$1;
    }

    public long defaultLifespanTime() {
        return this.defaultLifespanTime;
    }

    public void defaultLifespanTime_$eq(long x$1) {
        this.defaultLifespanTime = x$1;
    }

    public long defaultMaxIdleTime() {
        return this.defaultMaxIdleTime;
    }

    public void defaultMaxIdleTime_$eq(long x$1) {
        this.defaultMaxIdleTime = x$1;
    }

    public byte[] key() {
        return this.key;
    }

    public void key_$eq(byte[] x$1) {
        this.key = x$1;
    }

    public byte[] rawValue() {
        return this.rawValue;
    }

    public void rawValue_$eq(byte[] x$1) {
        this.rawValue = x$1;
    }

    public RequestParameters params() {
        return this.params;
    }

    public void params_$eq(RequestParameters x$1) {
        this.params = x$1;
    }

    public void resetParams() {
        this.params_$eq(null);
        this.rawValue_$eq(null);
    }

    public Object createErrorResponse(Throwable t) {
        ErrorResponse errorResponse;
        Throwable throwable = t;
        if (throwable instanceof DecoderException) {
            ErrorResponse errorResponse2;
            DecoderException decoderException = (DecoderException)throwable;
            Throwable throwable2 = decoderException.getCause();
            if (throwable2 instanceof HotRodException) {
                HotRodException hotRodException = (HotRodException)throwable2;
                errorResponse2 = hotRodException.response();
            } else {
                errorResponse2 = this.createErrorResponseBeforeReadingRequest(t);
            }
            errorResponse = errorResponse2;
        } else if (throwable instanceof HotRodException) {
            HotRodException hotRodException = (HotRodException)throwable;
            errorResponse = hotRodException.response();
        } else {
            errorResponse = throwable instanceof ClosedChannelException ? null : this.createErrorResponseBeforeReadingRequest(t);
        }
        return errorResponse;
    }

    private ErrorResponse createErrorResponseBeforeReadingRequest(Throwable t) {
        this.logErrorBeforeReadingRequest(t);
        return new ErrorResponse(0, 0L, "", 1, OperationStatus$.MODULE$.ServerError(), 0, t.toString());
    }

    public Tuple2<HotRodException, Object> createServerException(Exception e, ByteBuf b) {
        Exception exception;
        block8: {
            Tuple2 tuple2;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    exception = e;
                                    if (!(exception instanceof InvalidMagicIdException)) break block2;
                                    InvalidMagicIdException invalidMagicIdException = (InvalidMagicIdException)exception;
                                    this.logExceptionReported(invalidMagicIdException);
                                    tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(0, 0L, "", 1, OperationStatus$.MODULE$.InvalidMagicOrMsgId(), 0, invalidMagicIdException.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                    break block3;
                                }
                                if (!(exception instanceof HotRodUnknownOperationException)) break block4;
                                HotRodUnknownOperationException hotRodUnknownOperationException = (HotRodUnknownOperationException)exception;
                                this.logExceptionReported(hotRodUnknownOperationException);
                                tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(hotRodUnknownOperationException.version(), hotRodUnknownOperationException.messageId(), "", 1, OperationStatus$.MODULE$.UnknownOperation(), 0, hotRodUnknownOperationException.toString()), (Throwable)hotRodUnknownOperationException), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                break block3;
                            }
                            if (!(exception instanceof UnknownVersionException)) break block5;
                            UnknownVersionException unknownVersionException = (UnknownVersionException)exception;
                            this.logExceptionReported(unknownVersionException);
                            tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(unknownVersionException.version(), unknownVersionException.messageId(), "", 1, OperationStatus$.MODULE$.UnknownVersion(), 0, unknownVersionException.toString()), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break block3;
                        }
                        if (!(exception instanceof RequestParsingException)) break block6;
                        RequestParsingException requestParsingException = (RequestParsingException)exception;
                        this.logExceptionReported(requestParsingException);
                        String msg = requestParsingException.getCause() == null ? requestParsingException.toString() : new StringOps(Predef$.MODULE$.augmentString("%s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestParsingException.getMessage(), requestParsingException.getCause().toString()}));
                        tuple2 = new Tuple2((Object)new HotRodException(new ErrorResponse(requestParsingException.version(), requestParsingException.messageId(), "", 1, OperationStatus$.MODULE$.ParseError(), 0, msg), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break block3;
                    }
                    if (!(exception instanceof IllegalStateException)) break block7;
                    IllegalStateException illegalStateException = (IllegalStateException)exception;
                    this.logExceptionReported(illegalStateException);
                    tuple2 = new Tuple2((Object)new HotRodException(this.decoder().createErrorResponse(this.header(), illegalStateException), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break block3;
                }
                if (exception == null) break block8;
                Exception exception2 = exception;
                tuple2 = new Tuple2((Object)new HotRodException(this.decoder().createErrorResponse(this.header(), exception2), (Throwable)e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return tuple2;
        }
        throw new MatchError((Object)exception);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause, Function0<BoxedUnit> postCall) {
        BoxedUnit boxedUnit;
        Channel ch = ctx.channel();
        this.debug(cause, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Exception caught";
            }
        });
        if (cause instanceof IOException) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object errorResponse = this.createErrorResponse(cause);
            if (errorResponse == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object;
                Object object2 = errorResponse;
                if (object2 instanceof byte[]) {
                    byte[] byArray = (byte[])object2;
                    object = ch.writeAndFlush((Object)ExtendedByteBuf$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{byArray})));
                } else if (object2 instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)object2;
                    object = ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)charSequence, (Charset)CharsetUtil.UTF_8));
                } else {
                    object = object2 == null ? BoxedUnit.UNIT : ch.writeAndFlush(errorResponse);
                }
                boxedUnit = object;
            }
        }
        postCall.apply$mcV$sp();
    }

    public Response replace() {
        byte[] prev = (byte[])this.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).get((Object)this.key());
        if (prev != null) {
            prev = (byte[])this.cache().replace((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        }
        return prev != null ? this.successResp(prev) : this.notExecutedResp(prev);
    }

    public void obtainCache(EmbeddedCacheManager cacheManager) {
        String cacheName = this.header().cacheName();
        if (cacheName.startsWith(HotRodServerConfiguration.TOPOLOGY_CACHE_NAME_PREFIX)) {
            throw new RequestParsingException(new StringOps(Predef$.MODULE$.augmentString("Remote requests are not allowed to topology cache. Do no send remote requests to cache '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cacheName})), this.header().version(), this.header().messageId());
        }
        boolean seenForFirstTime = false;
        if (this.server.isCacheNameKnown(cacheName)) {
            if (cacheManager.getCacheNames().contains(cacheName)) {
                seenForFirstTime = true;
            } else {
                this.isError_$eq(true);
                throw new CacheNotFoundException(new StringOps(Predef$.MODULE$.augmentString("Cache with name '%s' not found amongst the configured caches")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cacheName})), this.header().version(), this.header().messageId());
            }
        }
        AdvancedCache<byte[], byte[]> cache = this.server.getCacheInstance(cacheName, cacheManager, seenForFirstTime);
        this.cache_$eq((AdvancedCache<byte[], byte[]>)this.decoder().getOptimizedCache(this.header(), cache).getAdvancedCache());
    }

    private Metadata buildMetadata() {
        Tuple2.mcII.sp sp2;
        block5: {
            EmbeddedMetadata.Builder metadata;
            block3: {
                Metadata.Builder builder;
                block4: {
                    block2: {
                        metadata = new EmbeddedMetadata.Builder();
                        metadata.version(this.generateVersion(this.server.getCacheRegistry(this.header().cacheName()), (Cache<byte[], byte[]>)this.cache()));
                        sp2 = new Tuple2.mcII.sp(this.params().lifespan(), this.params().maxIdle());
                        if (sp2 == null) break block2;
                        int n = sp2._1$mcI$sp();
                        int n2 = sp2._2$mcI$sp();
                        if (this.EXPIRATION_DEFAULT() != n || this.EXPIRATION_DEFAULT() != n2) break block2;
                        builder = metadata.lifespan(this.defaultLifespanTime()).maxIdle(this.defaultMaxIdleTime());
                        break block3;
                    }
                    if (sp2 == null) break block4;
                    int n = sp2._2$mcI$sp();
                    if (this.EXPIRATION_DEFAULT() != n) break block4;
                    builder = metadata.lifespan(this.toMillis(this.params().lifespan())).maxIdle(this.defaultMaxIdleTime());
                    break block3;
                }
                if (sp2 == null) break block5;
                builder = metadata.lifespan(this.toMillis(this.params().lifespan())).maxIdle(this.toMillis(this.params().maxIdle()));
            }
            return metadata.build();
        }
        throw new MatchError((Object)sp2);
    }

    public Response get(byte[] keyBytes) {
        return this.createGetResponse((CacheEntry<byte[], byte[]>)this.cache().getCacheEntry((Object)keyBytes));
    }

    public Response replaceIfUnmodified() {
        Response response;
        CacheEntry entry = this.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntry((Object)this.key());
        if (entry == null) {
            response = this.notExistResp();
        } else {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params().streamVersion());
            EntryVersion entryVersion = entry.getMetadata().version();
            NumericVersion numericVersion = streamVersion;
            if (!(entryVersion != null ? !entryVersion.equals(numericVersion) : numericVersion != null)) {
                byte[] v = this.rawValue();
                boolean replaced = this.cache().replace((Object)this.key(), (Object)prev, (Object)v, this.buildMetadata());
                response = replaced ? this.successResp(prev) : this.notExecutedResp(prev);
            } else {
                response = this.notExecutedResp(prev);
            }
        }
        return response;
    }

    public Response putIfAbsent() {
        byte[] prev = (byte[])this.cache().get((Object)this.key());
        if (prev == null) {
            prev = (byte[])this.cache().putIfAbsent((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        }
        return prev == null ? this.successResp(prev) : this.notExecutedResp(prev);
    }

    public Response put() {
        byte[] prev = (byte[])this.cache().put((Object)this.key(), (Object)this.rawValue(), this.buildMetadata());
        return this.successResp(prev);
    }

    public EntryVersion generateVersion(ComponentRegistry registry, Cache<byte[], byte[]> cache) {
        IncrementableEntryVersion incrementableEntryVersion;
        VersionGenerator cacheVersionGenerator = (VersionGenerator)registry.getComponent(VersionGenerator.class);
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            incrementableEntryVersion = newVersionGenerator.generateNew();
        } else {
            incrementableEntryVersion = cacheVersionGenerator.generateNew();
        }
        return incrementableEntryVersion;
    }

    public Response remove() {
        byte[] prev = (byte[])this.cache().remove((Object)this.key());
        return prev != null ? this.successResp(prev) : this.notExistResp();
    }

    public Response successResp(byte[] prev) {
        return this.decoder().createSuccessResponse(this.header(), prev);
    }

    public Response notExecutedResp(byte[] prev) {
        return this.decoder().createNotExecutedResponse(this.header(), prev);
    }

    public Response notExistResp() {
        return this.decoder().createNotExistResponse(this.header());
    }

    public Response createGetResponse(CacheEntry<byte[], byte[]> entry) {
        return this.decoder().createGetResponse(this.header(), entry);
    }

    public Object createMultiGetResponse(Map<byte[], CacheEntry<byte[], byte[]>> pairs) {
        return null;
    }

    public long toMillis(int lifespan) {
        long unixTimeExpiry;
        return lifespan > this.SecondsInAMonth() ? ((unixTimeExpiry = TimeUnit.SECONDS.toMillis(lifespan) - System.currentTimeMillis()) < 0L ? 0L : unixTimeExpiry) : TimeUnit.SECONDS.toMillis(lifespan);
    }

    public CacheDecodeContext(HotRodServer server) {
        this.server = server;
        ServerConstants.class.$init$((ServerConstants)this);
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log$class.$init$(this);
        this.isTrace = this.isTraceEnabled();
        this.SecondsInAMonth = 2592000;
        this.isError = false;
    }
}

