/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;
import org.slf4j.Logger;

public class ExceptionHolderImpl
extends ExceptionHolder
implements Configurable {
    private Logger logger = null;

    public ExceptionHolderImpl() {
    }

    public ExceptionHolderImpl(ReplyInputStream inputStream) {
        this();
        int status = inputStream.getStatus().value();
        if (status == 1) {
            this.is_system_exception = false;
        } else if (status == 2) {
            this.is_system_exception = true;
        } else {
            throw new BAD_PARAM("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = inputStream.littleEndian;
        this.marshaled_exception = inputStream.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionHolderImpl(SystemException exception) {
        this();
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream output = new CDROutputStream();
        try {
            SystemExceptionHelper.write(output, exception);
            this.marshaled_exception = output.getBufferCopy();
        }
        finally {
            output.close();
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("jacorb.orb.exc_holder");
    }

    public void raise_exception() throws UserException {
        CDRInputStream input = new CDRInputStream(this.marshaled_exception, this.byte_order);
        try {
            if (this.is_system_exception) {
                throw SystemExceptionHelper.read(input);
            }
            input.mark(0);
            String id = input.read_string();
            try {
                input.reset();
            }
            catch (IOException e) {
                this.logger.warn("Unexpected IOException: ", (Throwable)e);
            }
            UserException result = null;
            try {
                result = this.exceptionFromHelper(id, input);
            }
            catch (Exception e) {
                throw new UnknownUserException();
            }
            throw result;
        }
        catch (Throwable throwable) {
            input.close();
            throw throwable;
        }
    }

    public void raise_exception_with_list(ExceptionList exc_list) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            result.append(this.marshaled_exception[i]);
            result.append('(');
            result.append((char)this.marshaled_exception[i]);
            result.append(")  ");
        }
        return result.toString();
    }

    public UserException exceptionFromHelper(String id, InputStream input) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String name = RepositoryID.className(id, "Helper", null);
        Class helperClazz = ObjectUtil.classForName(name);
        Method readMethod = helperClazz.getMethod("read", ObjectUtil.classForName("org.omg.CORBA.portable.InputStream"));
        Object result = readMethod.invoke(null, input);
        return (UserException)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] marshal() {
        CDROutputStream output = new CDROutputStream();
        try {
            output.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
            byte[] byArray = output.getBufferCopy();
            return byArray;
        }
        finally {
            output.close();
        }
    }
}

