/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;

public class LevelDBStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<LevelDBStoreConfiguration, LevelDBStoreConfigurationBuilder> {
    protected String location = "Infinispan-LevelDBStore/data";
    protected String expiredLocation = "Infinispan-LevelDBStore/expired";
    protected CompressionType compressionType = CompressionType.NONE;
    protected LevelDBStoreConfiguration.ImplementationType implementationType = LevelDBStoreConfiguration.ImplementationType.AUTO;
    protected Integer blockSize;
    protected Long cacheSize;
    protected int expiryQueueSize = 10000;
    protected int clearThreshold = 10000;

    public LevelDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public LevelDBStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder expiredLocation(String expiredLocation) {
        this.expiredLocation = expiredLocation;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder implementationType(LevelDBStoreConfiguration.ImplementationType implementationType) {
        this.implementationType = implementationType;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder cacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder expiryQueueSize(int expiryQueueSize) {
        this.expiryQueueSize = expiryQueueSize;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder clearThreshold(int clearThreshold) {
        this.clearThreshold = clearThreshold;
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder compressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this.self();
    }

    public void validate() {
        super.validate();
    }

    public LevelDBStoreConfiguration create() {
        return new LevelDBStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.location, this.expiredLocation, this.implementationType, this.compressionType, this.blockSize, this.cacheSize, this.expiryQueueSize, this.clearThreshold);
    }

    public Builder<?> read(LevelDBStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.location = template.location();
        this.expiredLocation = template.expiredLocation();
        this.implementationType = template.implementationType();
        this.preload = template.preload();
        this.shared = template.shared();
        this.compressionType = template.compressionType();
        this.blockSize = template.blockSize();
        this.cacheSize = template.cacheSize();
        this.expiryQueueSize = template.expiryQueueSize();
        this.clearThreshold = template.clearThreshold();
        return this.self();
    }

    public LevelDBStoreConfigurationBuilder self() {
        return this;
    }
}

