/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.client.impl.ClientLargeMessageImpl;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveClientLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;

public class ClientPacketDecoder
extends PacketDecoder {
    private static final long serialVersionUID = 6952614096979334582L;
    public static final ClientPacketDecoder INSTANCE = new ClientPacketDecoder();

    @Override
    public Packet decode(HornetQBuffer in) {
        Packet packet;
        byte packetType = in.readByte();
        switch (packetType) {
            case 75: {
                packet = new SessionReceiveMessage(new ClientMessageImpl());
                break;
            }
            case 76: {
                packet = new SessionReceiveClientLargeMessage(new ClientLargeMessageImpl());
                break;
            }
            default: {
                packet = super.decode(packetType);
            }
        }
        packet.decode(in);
        return packet;
    }
}

