/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.util.logging.Log;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface JavaLog
extends Log {
    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Start main with args: %s", id=5001)
    public void startWithArgs(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Posting Shutdown Request to the server...", id=5002)
    public void postingShutdownRequest();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported", id=5003)
    public void exceptionReported(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Server channel group did not completely unbind", id=5004)
    public void serverDidNotUnbind();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still bound to %s", id=5005)
    public void channelStillBound(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Channel group did not completely close", id=5006)
    public void serverDidNotClose();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still connected to %s", id=5007)
    public void channelStillConnected(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Setting the number of master threads is no longer supported", id=5008)
    public void settingMasterThreadsNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error before any request parameters read", id=5009)
    public void errorBeforeReadingRequest(@Cause Throwable var1);

    @Message(value="Illegal number of workerThreads: %d", id=5010)
    public IllegalArgumentException illegalWorkerThreads(int var1);

    @Message(value="Idle timeout can't be lower than -1: %d", id=5011)
    public IllegalArgumentException illegalIdleTimeout(int var1);

    @Message(value="Receive Buffer Size can't be lower than 0: %d", id=5012)
    public IllegalArgumentException illegalReceiveBufferSize(int var1);

    @Message(value="Send Buffer Size can't be lower than 0: %d", id=5013)
    public IllegalArgumentException illegalSendBufferSize(int var1);

    @Message(value="SSL Enabled but no KeyStore specified", id=5014)
    public CacheConfigurationException noSSLKeyManagerConfiguration();

    @Message(value="SSL Enabled but no TrustStore specified", id=5015)
    public CacheConfigurationException noSSLTrustManagerConfiguration();

    @Message(value="A password is required to open the KeyStore '%s'", id=5016)
    public CacheConfigurationException missingKeyStorePassword(String var1);

    @Message(value="A password is required to open the TrustStore '%s'", id=5017)
    public CacheConfigurationException missingTrustStorePassword(String var1);

    @Message(value="Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext", id=5018)
    public CacheConfigurationException xorSSLContext();
}

