/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderService;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;

public class PassivationStoreAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;

    PassivationStoreAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        int initialMaxSize = PassivationStoreResourceDefinition.MAX_SIZE.resolveModelAttribute(context, model).asInt();
        String containerName = PassivationStoreResourceDefinition.CACHE_CONTAINER.resolveModelAttribute(context, model).asString();
        ModelNode beanCacheNode = PassivationStoreResourceDefinition.BEAN_CACHE.resolveModelAttribute(context, model);
        String cacheName = beanCacheNode.isDefined() ? beanCacheNode.asString() : null;
        this.install(context, operation, initialMaxSize, containerName, cacheName, verificationHandler, serviceControllers);
    }

    protected void install(OperationContext context, ModelNode operation, final int initialMaxSize, final String containerName, final String cacheName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        BeanManagerFactoryBuilderConfiguration config = new BeanManagerFactoryBuilderConfiguration(){
            private volatile int maxSize;
            {
                this.maxSize = initialMaxSize;
            }

            public String getContainerName() {
                return containerName;
            }

            public String getCacheName() {
                return cacheName;
            }

            public int getMaxSize() {
                return this.maxSize;
            }

            public void setMaxSize(int size) {
                this.maxSize = size;
            }
        };
        ServiceBuilder builder = new DistributableCacheFactoryBuilderService(name, config).build(context.getServiceTarget()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        serviceControllers.add(builder.install());
    }
}

