/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class ServerPacketDecoder
extends PacketDecoder {
    private static final long serialVersionUID = 3348673114388400766L;
    public static final ServerPacketDecoder INSTANCE = new ServerPacketDecoder();

    public Packet decode(HornetQBuffer in) {
        PacketImpl packet;
        byte packetType = in.readByte();
        switch (packetType) {
            case 71: {
                packet = new SessionSendMessage((MessageInternal)new ServerMessageImpl());
                break;
            }
            case 72: {
                packet = new SessionSendLargeMessage((MessageInternal)new ServerMessageImpl());
                break;
            }
            case 91: {
                packet = new ReplicationAddMessage();
                break;
            }
            case 92: {
                packet = new ReplicationAddTXMessage();
                break;
            }
            case 93: {
                packet = new ReplicationDeleteMessage();
                break;
            }
            case 94: {
                packet = new ReplicationDeleteTXMessage();
                break;
            }
            case 95: {
                packet = new ReplicationPrepareMessage();
                break;
            }
            case 96: {
                packet = new ReplicationCommitMessage();
                break;
            }
            case 90: {
                packet = new ReplicationResponseMessage();
                break;
            }
            case 97: {
                packet = new ReplicationPageWriteMessage();
                break;
            }
            case 98: {
                packet = new ReplicationPageEventMessage();
                break;
            }
            case 99: {
                packet = new ReplicationLargeMessageBeginMessage();
                break;
            }
            case 100: {
                packet = new ReplicationLargeMessageEndMessage();
                break;
            }
            case 101: {
                packet = new ReplicationLargeMessageWriteMessage();
                break;
            }
            case 115: {
                packet = new BackupRegistrationMessage();
                break;
            }
            case 116: {
                packet = new BackupReplicationStartFailedMessage();
                break;
            }
            case 120: {
                packet = new ReplicationStartSyncMessage();
                break;
            }
            case 103: {
                packet = new ReplicationSyncFileMessage();
                break;
            }
            case 121: {
                packet = new ReplicationLiveIsStoppingMessage();
                break;
            }
            default: {
                packet = super.decode(packetType);
            }
        }
        packet.decode(in);
        return packet;
    }
}

