/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.remote.ExternalizerIds;

public final class ProtobufValueWrapper {
    private final byte[] binary;
    private int hashCode = 0;

    public ProtobufValueWrapper(byte[] binary) {
        this.binary = binary;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufValueWrapper that = (ProtobufValueWrapper)o;
        return Arrays.equals(this.binary, that.binary);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.binary);
        }
        return this.hashCode;
    }

    public String toString() {
        return "ProtobufValueWrapper(" + Arrays.toString(this.binary) + ')';
    }

    public static final class Externalizer
    extends AbstractExternalizer<ProtobufValueWrapper> {
        public void writeObject(ObjectOutput output, ProtobufValueWrapper protobufValueWrapper) throws IOException {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)protobufValueWrapper.getBinary().length);
            output.write(protobufValueWrapper.getBinary());
        }

        public ProtobufValueWrapper readObject(ObjectInput input) throws IOException {
            int length = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            byte[] binary = new byte[length];
            input.readFully(binary);
            return new ProtobufValueWrapper(binary);
        }

        public Integer getId() {
            return ExternalizerIds.PROTOBUF_VALUE_WRAPPER;
        }

        public Set<Class<? extends ProtobufValueWrapper>> getTypeClasses() {
            return Collections.singleton(ProtobufValueWrapper.class);
        }
    }
}

