/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import java.util.Collections;
import java.util.HashMap;
import javax.resource.spi.TransactionSupport;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.Connector10;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.v11.CommonConnDefImpl;
import org.jboss.jca.common.metadata.ironjacamar.v11.IronJacamarImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public class DirectConnectionFactoryActivatorService
implements Service<ContextNames.BindInfo> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"connector"}).append(new String[]{"direct-connection-factory-activator"});
    protected final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();
    private final String jndiName;
    private final String interfaceName;
    private final String resourceAdapter;
    private final String raId;
    private final int maxPoolSize;
    private final int minPoolSize;
    private final String[] properties;
    private final TransactionSupport.TransactionSupportLevel transactionSupport;
    private final Module module;
    private final ContextNames.BindInfo bindInfo;

    public DirectConnectionFactoryActivatorService(String jndiName, String interfaceName, String resourceAdapter, String raId, int maxPoolSize, int minPoolSize, String[] properties, TransactionSupport.TransactionSupportLevel transactionSupport, Module module, ContextNames.BindInfo bindInfo) {
        this.jndiName = jndiName;
        this.interfaceName = interfaceName;
        this.resourceAdapter = resourceAdapter;
        this.raId = raId;
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
        this.properties = properties;
        if (transactionSupport == null) {
            transactionSupport = TransactionSupport.TransactionSupportLevel.NoTransaction;
        }
        this.transactionSupport = transactionSupport;
        this.module = module;
        this.bindInfo = bindInfo;
    }

    public ContextNames.BindInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.bindInfo;
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("started DirectConnectionFactoryActivatorService %s", context.getController().getName());
        String cfInterface = null;
        try {
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.raId);
            if (cmd.getVersion() == Connector.Version.V_10) {
                Connector10 c10 = (Connector10)cmd;
                ResourceAdapter10 ra10 = (ResourceAdapter10)c10.getResourceadapter();
                cfInterface = ra10.getConnectionFactoryInterface().getValue();
            } else {
                ResourceAdapter1516 ra1516 = (ResourceAdapter1516)cmd.getResourceadapter();
                if (ra1516.getOutboundResourceadapter() != null) {
                    for (ConnectionDefinition cd : ra1516.getOutboundResourceadapter().getConnectionDefinitions()) {
                        if (!cd.getConnectionFactoryInterface().getValue().equals(this.interfaceName)) continue;
                        cfInterface = cd.getConnectionFactoryInterface().getValue();
                    }
                }
            }
            if (cfInterface == null || !cfInterface.equals(this.interfaceName)) {
                throw ConnectorMessages.MESSAGES.invalidConnectionFactory(cfInterface, this.resourceAdapter, this.jndiName);
            }
            HashMap<String, String> raConfigProperties = new HashMap<String, String>();
            HashMap<String, String> mcfConfigProperties = new HashMap<String, String>();
            String securitySetting = null;
            String securitySettingDomain = null;
            if (this.properties != null) {
                for (String prop : this.properties) {
                    if (prop.startsWith("ironjacamar.security")) {
                        securitySetting = prop.substring(prop.indexOf("=") + 1);
                        continue;
                    }
                    if (prop.startsWith("ironjacamar.security.domain")) {
                        securitySettingDomain = prop.substring(prop.indexOf("=") + 1);
                        continue;
                    }
                    String key = prop.substring(0, prop.indexOf("="));
                    String value = prop.substring(prop.indexOf("=") + 1);
                    if (key.startsWith("ra.")) {
                        raConfigProperties.put(key.substring(3), value);
                        continue;
                    }
                    if (key.startsWith("mcf.")) {
                        mcfConfigProperties.put(key.substring(4), value);
                        continue;
                    }
                    mcfConfigProperties.put(key, value);
                }
            }
            String mcfClass = null;
            if (cmd.getVersion() == Connector.Version.V_10) {
                Connector10 c10 = (Connector10)cmd;
                ResourceAdapter10 ra10 = (ResourceAdapter10)c10.getResourceadapter();
                mcfClass = ra10.getManagedConnectionFactoryClass().getValue();
            } else {
                ResourceAdapter1516 ra1516 = (ResourceAdapter1516)cmd.getResourceadapter();
                if (ra1516.getOutboundResourceadapter() != null) {
                    for (ConnectionDefinition cd : ra1516.getOutboundResourceadapter().getConnectionDefinitions()) {
                        if (!cd.getConnectionFactoryInterface().getValue().equals(cfInterface)) continue;
                        mcfClass = cd.getManagedConnectionFactoryClass().getValue();
                    }
                }
            }
            CommonSecurityImpl security = null;
            if (securitySetting != null) {
                if ("".equals(securitySetting)) {
                    security = new CommonSecurityImpl(null, null, false);
                } else if ("application".equals(securitySetting)) {
                    security = new CommonSecurityImpl(null, null, true);
                } else if ("domain".equals(securitySetting) && securitySettingDomain != null) {
                    security = new CommonSecurityImpl(securitySettingDomain, null, false);
                } else if ("domain-and-application".equals(securitySetting) && securitySettingDomain != null) {
                    security = new CommonSecurityImpl(null, securitySettingDomain, false);
                }
            }
            if (security == null) {
                ConnectorLogger.SUBSYSTEM_RA_LOGGER.noSecurityDefined(this.jndiName);
            }
            CommonPoolImpl pool = null;
            Boolean isXA = Boolean.FALSE;
            if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction) {
                pool = new CommonXaPoolImpl(Integer.valueOf(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Integer.valueOf(this.maxPoolSize < 0 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
                isXA = Boolean.TRUE;
            } else {
                pool = new CommonPoolImpl(Integer.valueOf(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Integer.valueOf(this.maxPoolSize < 0 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY);
            }
            TransactionSupportEnum transactionSupportValue = TransactionSupportEnum.NoTransaction;
            if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction) {
                transactionSupportValue = TransactionSupportEnum.XATransaction;
            } else if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.LocalTransaction) {
                transactionSupportValue = TransactionSupportEnum.LocalTransaction;
            }
            CommonConnDefImpl cd = new CommonConnDefImpl(mcfConfigProperties, mcfClass, this.jndiName, this.poolName(cfInterface), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, (CommonPool)pool, null, null, (CommonSecurity)security, null, isXA);
            IronJacamarImpl ijmd = new IronJacamarImpl(transactionSupportValue, raConfigProperties, null, Collections.singletonList(cd), Collections.emptyList(), null, null);
            String serviceName = this.jndiName;
            serviceName = serviceName.replace(':', '_');
            serviceName = serviceName.replace('/', '_');
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService(cmd, (IronJacamar)ijmd, (ClassLoader)this.module.getClassLoader(), serviceName);
            activator.setCreateBinderService(false);
            activator.setBindInfo(this.bindInfo);
            ServiceTarget serviceTarget = context.getChildTarget();
            ServiceName activatorServiceName = ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{serviceName});
            ServiceBuilder connectionFactoryServiceBuilder = serviceTarget.addService(activatorServiceName, (Service)activator).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, activator.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector()).addDependency(NamingService.SERVICE_NAME).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            connectionFactoryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("stopped DirectConnectionFactoryActivatorService %s", context.getController().getName());
    }

    private String poolName(String cfInterface) {
        if (cfInterface.indexOf(".") != -1) {
            return cfInterface.substring(cfInterface.lastIndexOf(".") + 1);
        }
        return cfInterface;
    }
}

