/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import javax.management.ObjectName;
import org.jboss.as.jsr77.JSR77Messages;

public class ObjectNameBuilder {
    final StringBuilder sb;

    private ObjectNameBuilder(String j2eeType, String name) {
        this.sb = new StringBuilder("jboss.jsr77:j2eeType=" + j2eeType + ",name=" + name);
    }

    static ObjectNameBuilder createPlain(String j2eeType, String name) {
        return new ObjectNameBuilder(j2eeType, name);
    }

    static ObjectNameBuilder createServerChild(String j2eeType, String name) {
        return new ObjectNameBuilder(j2eeType, name).append("J2EEServer", "default");
    }

    ObjectNameBuilder append(String key, String value) {
        this.sb.append("," + key + "=" + value);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    ObjectName toObjectName() {
        try {
            return new ObjectName(this.toString());
        }
        catch (Exception e) {
            throw JSR77Messages.MESSAGES.invalidObjectName(e, this.toString());
        }
    }

    static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw JSR77Messages.MESSAGES.couldNotCreateObjectName(e, name);
        }
    }
}

