/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.Time;

public class SimpleSessionMetaDataExternalizer
extends AbstractSimpleExternalizer<SimpleSessionMetaData> {
    private static final long serialVersionUID = 1371677643229192026L;

    public SimpleSessionMetaDataExternalizer() {
        super(SimpleSessionMetaData.class);
    }

    public void writeObject(ObjectOutput output, SimpleSessionMetaData metaData) throws IOException {
        output.writeLong(metaData.getCreationTime().getTime());
        output.writeLong(metaData.getLastAccessedTime().getTime());
        output.writeInt((int)metaData.getMaxInactiveInterval(TimeUnit.SECONDS));
    }

    public SimpleSessionMetaData readObject(ObjectInput input) throws IOException {
        Date creationTime = new Date(input.readLong());
        Date lastAccessedTime = new Date(input.readLong());
        Time maxInactiveInterval = new Time(input.readInt(), TimeUnit.SECONDS);
        return new SimpleSessionMetaData(creationTime, lastAccessedTime, maxInactiveInterval);
    }
}

