/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerHost;

public class ReverseProxyHandler
extends Handler {
    public static final AttributeDefinition PROBLEM_SERVER_RETRY = new SimpleAttributeDefinitionBuilder("problem-server-retry", ModelType.INT).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(30)).build();
    public static final AttributeDefinition SESSION_COOKIE_NAMES = new SimpleAttributeDefinitionBuilder("session-cookie-names", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode("JSESSIONID")).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).build();
    public static final ReverseProxyHandler INSTANCE = new ReverseProxyHandler();

    private ReverseProxyHandler() {
        super("reverse-proxy");
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(CONNECTIONS_PER_THREAD, SESSION_COOKIE_NAMES, PROBLEM_SERVER_RETRY);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.singletonList(ReverseProxyHandlerHost.INSTANCE);
    }

    @Override
    public HttpHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
        String[] sessionIds;
        String sessionCookieNames = SESSION_COOKIE_NAMES.resolveModelAttribute(context, model).asString();
        int connectionsPerThread = CONNECTIONS_PER_THREAD.resolveModelAttribute(context, model).asInt();
        int problemServerRetry = PROBLEM_SERVER_RETRY.resolveModelAttribute(context, model).asInt();
        int maxTime = MAX_REQUEST_TIME.resolveModelAttribute(context, model).asInt();
        LoadBalancingProxyClient lb = new LoadBalancingProxyClient(new ExclusivityChecker(){

            public boolean isExclusivityRequired(HttpServerExchange exchange) {
                return exchange.getRequestHeaders().contains(Headers.UPGRADE);
            }
        }).setConnectionsPerThread(connectionsPerThread).setProblemServerRetry(problemServerRetry);
        for (String id : sessionIds = sessionCookieNames.split(",")) {
            lb.addSessionCookieName(id);
        }
        ProxyHandler handler = new ProxyHandler((ProxyClient)lb, maxTime, (HttpHandler)ResponseCodeHandler.HANDLE_404);
        return handler;
    }
}

