/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.idm.Account;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AccountImpl
implements Account,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Set<String> roles = new CopyOnWriteArraySet<String>();
    private final Principal principal;
    private final Object credential;

    public AccountImpl(String name) {
        this.name = name;
        this.principal = new AccountPrincipal();
        this.credential = null;
    }

    public AccountImpl(Principal principal) {
        this.principal = principal;
        this.name = principal.getName();
        this.credential = null;
    }

    public AccountImpl(Principal principal, Set<String> roles, Object credential) {
        this.principal = principal;
        this.credential = credential;
        this.name = principal.getName();
        this.roles.addAll(roles);
    }

    void setRoles(Set<String> roles) {
        this.roles.clear();
        roles.addAll(roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountImpl account = (AccountImpl)o;
        return !(this.name != null ? !this.name.equals(account.name) : account.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Object getCredential() {
        return this.credential;
    }

    private final class AccountPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AccountPrincipal() {
        }

        @Override
        public String getName() {
            return AccountImpl.this.name;
        }

        @Override
        public int hashCode() {
            return AccountImpl.this.name.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof AccountPrincipal ? this.equals((AccountPrincipal)obj) : false;
        }

        private boolean equals(AccountPrincipal other) {
            return AccountImpl.this.name.equals(other.getName());
        }
    }
}

