/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.Attribute;
import org.infinispan.server.endpoint.subsystem.CommonConnectorResource;
import org.infinispan.server.endpoint.subsystem.Element;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.TopologyStateTransferResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EndpointSubsystemReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    EndpointSubsystemReader_1_0() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{Constants.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        operations.add(subsystem);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HOTROD_CONNECTOR: {
                    this.parseHotRodConnector(reader, subsystemAddress, operations);
                    continue block5;
                }
                case MEMCACHED_CONNECTOR: {
                    this.parseMemcachedConnector(reader, subsystemAddress, operations);
                    continue block5;
                }
                case REST_CONNECTOR: {
                    this.parseRestConnector(reader, subsystemAddress, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHotRodConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "hotrod-connector";
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            name = this.parseConnectorAttributes(reader, connector, name, i, value, attribute);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"hotrod-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        operations.add(connector);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TOPOLOGY_STATE_TRANSFER: {
                    this.parseTopologyStateTransfer(reader, connector, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMemcachedConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "memcached-connector";
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            name = this.parseConnectorAttributes(reader, connector, name, i, value, attribute);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"memcached-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(connector);
    }

    private String parseConnectorAttributes(XMLExtendedStreamReader reader, ModelNode connector, String name, int i, String value, Attribute attribute) throws XMLStreamException {
        switch (attribute) {
            case CACHE_CONTAINER: {
                CommonConnectorResource.CACHE_CONTAINER.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case IDLE_TIMEOUT: {
                ProtocolServerConnectorResource.IDLE_TIMEOUT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case NAME: {
                CommonConnectorResource.NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                name = value;
                break;
            }
            case RECEIVE_BUFFER_SIZE: {
                ProtocolServerConnectorResource.RECEIVE_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case SEND_BUFFER_SIZE: {
                ProtocolServerConnectorResource.SEND_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case SOCKET_BINDING: {
                ProtocolServerConnectorResource.SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case TCP_NODELAY: {
                ProtocolServerConnectorResource.TCP_NODELAY.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case WORKER_THREADS: {
                ProtocolServerConnectorResource.WORKER_THREADS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
        }
        return name;
    }

    private void parseRestConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "rest-connector";
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTH_METHOD: {
                    RestConnectorResource.AUTH_METHOD.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                case CACHE_CONTAINER: {
                    CommonConnectorResource.CACHE_CONTAINER.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                case CONTEXT_PATH: {
                    RestConnectorResource.CONTEXT_PATH.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                case NAME: {
                    CommonConnectorResource.NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    name = value;
                    continue block9;
                }
                case SECURITY_DOMAIN: {
                    RestConnectorResource.SECURITY_DOMAIN.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                case SECURITY_MODE: {
                    RestConnectorResource.SECURITY_MODE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                case VIRTUAL_SERVER: {
                    RestConnectorResource.VIRTUAL_SERVER.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathAddress containerAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"rest-connector", (String)name)});
        connector.get("address").set(containerAddress.toModelNode());
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(connector);
    }

    private void parseTopologyStateTransfer(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"topology-state-transfer", (String)"TOPOLOGY_STATE_TRANSFER")});
        ModelNode topologyStateTransfer = Util.createAddOperation((PathAddress)address);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXTERNAL_HOST: {
                    TopologyStateTransferResource.EXTERNAL_HOST.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block8;
                }
                case EXTERNAL_PORT: {
                    TopologyStateTransferResource.EXTERNAL_PORT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block8;
                }
                case LAZY_RETRIEVAL: {
                    TopologyStateTransferResource.LAZY_RETRIEVAL.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block8;
                }
                case LOCK_TIMEOUT: {
                    TopologyStateTransferResource.LOCK_TIMEOUT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block8;
                }
                case REPLICATION_TIMEOUT: {
                    TopologyStateTransferResource.REPLICATION_TIMEOUT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block8;
                }
                case UPDATE_TIMEOUT: {
                    EndpointLogger.ROOT_LOGGER.topologyUpdateTimeoutIgnored();
                    continue block8;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(topologyStateTransfer);
    }
}

