/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.File;
import javax.servlet.ServletContext;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.ServerBootstrap;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.SecurityMode;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.security.JAASIdentityManagerImpl;

public class RestService
implements Service<Deployment> {
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String DEFAULT_CONTEXT_PATH = "";
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextInjector = new InjectedValue();
    private final InjectedValue<Host> hostInjector = new InjectedValue();
    private final ModelNode config;
    private final String path;
    private final String securityDomain;
    private final String authMethod;
    private final SecurityMode securityMode;
    private PathManager.Callback.Handle callbackHandle;
    private final RestServerConfiguration configuration;
    private final DeploymentInfo deployment = new DeploymentInfo();
    private DeploymentManager deploymentManager;

    public RestService(ModelNode config) {
        this.config = config.clone();
        this.path = this.config.hasDefined("context-path") ? RestService.cleanContextPath(this.config.get("context-path").asString()) : DEFAULT_CONTEXT_PATH;
        this.securityDomain = config.hasDefined("security-domain") ? config.get("security-domain").asString() : null;
        this.authMethod = config.hasDefined("auth-method") ? config.get("auth-method").asString() : "BASIC";
        this.securityMode = config.hasDefined("security-mode") ? SecurityMode.valueOf(config.get("security-mode").asString()) : SecurityMode.READ_WRITE;
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.extendedHeaders(config.hasDefined("extended-headers") ? ExtendedHeaders.valueOf((String)config.get("extended-headers").asString()) : ExtendedHeaders.ON_DEMAND);
        this.configuration = builder.build();
    }

    private static String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting("REST");
        try {
            this.deployment.setDeploymentName("REST").setContextPath(this.path).setClassLoader(this.getClass().getClassLoader()).addInitParameter("resteasy.resources", "org.infinispan.rest.Server").addInitParameter("resteasy.use.builtin.providers", "true").addListener(new ListenerInfo(ResteasyBootstrap.class)).addMimeMappings(new MimeMapping[]{new MimeMapping("html", "text/html"), new MimeMapping("jpg", "image/jpeg")}).addWelcomePage("index.html").setResourceManager((ResourceManager)new FileResourceManager(new File(((PathManager)this.pathManagerInjector.getValue()).resolveRelativePathEntry("rest", HOME_DIR)), 0x100000L));
            this.callbackHandle = ((PathManager)this.pathManagerInjector.getValue()).registerCallback(HOME_DIR, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
            this.deployment.addServlet(new ServletInfo("default", DefaultServlet.class).addMapping("/"));
            this.deployment.addServlet(new ServletInfo("Resteasy", HttpServletDispatcher.class).addMapping("/rest/*"));
            if (this.securityDomain != null) {
                this.configureContextSecurity();
            }
            this.deploymentManager = ((Host)this.hostInjector.getValue()).getServer().getServletContainer().getServletContainer().addDeployment(this.deployment);
            this.deploymentManager.deploy();
            ServletContextImpl servletContext = this.deploymentManager.getDeployment().getServletContext();
            ServerBootstrap.setCacheManager((ServletContext)servletContext, (EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagerInjector.getValue()));
            ServerBootstrap.setConfiguration((ServletContext)servletContext, (RestServerConfiguration)this.configuration);
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextCreationFailed(e);
        }
        try {
            HttpHandler httpHandler = this.deploymentManager.start();
            ((Host)this.hostInjector.getValue()).registerDeployment(this.deploymentManager.getDeployment(), httpHandler);
            EndpointLogger.ROOT_LOGGER.httpEndpointStarted("REST", this.path, "rest");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextStartFailed(e);
        }
    }

    private void configureContextSecurity() {
        SecurityConstraint constraint = new SecurityConstraint();
        WebResourceCollection webCollection = new WebResourceCollection();
        webCollection.addUrlPattern("/rest/*");
        switch (this.securityMode) {
            case WRITE: {
                webCollection.addHttpMethods(new String[]{"PUT", "POST", "DELETE"});
                break;
            }
        }
        constraint.addWebResourceCollection(webCollection);
        constraint.addRoleAllowed("REST");
        this.deployment.addSecurityConstraint(constraint);
        LoginConfig login = new LoginConfig("ApplicationRealm").addFirstAuthMethod(this.authMethod);
        this.deployment.setLoginConfig(login);
        this.deployment.addSecurityRole("REST");
        SecurityDomainContext securityDomainContext = (SecurityDomainContext)this.securityDomainContextInjector.getValue();
        this.deployment.setIdentityManager((IdentityManager)new JAASIdentityManagerImpl(securityDomainContext));
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public synchronized void stop(StopContext stopContext) {
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
        try {
            ((Host)this.hostInjector.getValue()).unregisterDeployment(this.deploymentManager.getDeployment());
            this.deploymentManager.stop();
        }
        catch (Exception e) {
            EndpointLogger.ROOT_LOGGER.contextStopFailed(e);
        }
        try {
            this.deploymentManager.undeploy();
            ((Host)this.hostInjector.getValue()).getServer().getServletContainer().getServletContainer().removeDeployment(this.deployment);
        }
        catch (Exception e) {
            EndpointLogger.ROOT_LOGGER.contextDestroyFailed(e);
        }
    }

    String getCacheContainerName() {
        if (!this.config.hasDefined("cache-container")) {
            return null;
        }
        return this.config.get("cache-container").asString();
    }

    public synchronized Deployment getValue() throws IllegalStateException {
        if (this.deploymentManager == null) {
            throw new IllegalStateException();
        }
        return this.deploymentManager.getDeployment();
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextInjector;
    }

    public Injector<Host> getHostInjector() {
        return this.hostInjector;
    }
}

