/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.infinispan.server.endpoint.subsystem.EndpointExtension;
import org.infinispan.server.endpoint.subsystem.SaslAdd;
import org.infinispan.server.endpoint.subsystem.SaslPolicyResource;
import org.infinispan.server.endpoint.subsystem.SaslPropertyResource;
import org.infinispan.server.endpoint.subsystem.SaslQop;
import org.infinispan.server.endpoint.subsystem.SaslStrength;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SaslResource
extends SimpleResourceDefinition {
    private static final PathElement SASL_PATH = PathElement.pathElement((String)"sasl", (String)"SASL");
    static final ListAttributeDefinition MECHANISMS = new StringListAttributeDefinition.Builder("mechanisms").build();
    static final ListAttributeDefinition QOP = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("qop").setAllowNull(true)).setValidator((ParameterValidator)QopParameterValidation.INSTANCE)).build();
    static final SimpleAttributeDefinition SERVER_CONTEXT_NAME = new SimpleAttributeDefinitionBuilder("server-context-name", ModelType.STRING, true).setAllowExpression(true).setXmlName("server-context-name").setRestartAllServices().build();
    static final SimpleAttributeDefinition SERVER_NAME = new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true).setXmlName("server-name").setRestartAllServices().build();
    static final ListAttributeDefinition STRENGTH = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("strength").setAllowNull(true)).setValidator((ParameterValidator)StrengthParameterValidation.INSTANCE)).build();
    static final AttributeDefinition[] SASL_ATTRIBUTES = new AttributeDefinition[]{MECHANISMS, QOP, SERVER_CONTEXT_NAME, SERVER_NAME, STRENGTH};

    SaslResource() {
        super(SASL_PATH, EndpointExtension.getResourceDescriptionResolver("sasl"), (OperationStepHandler)SaslAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new SaslPolicyResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new SaslPropertyResource());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(SASL_ATTRIBUTES);
        for (AttributeDefinition attr : SASL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    private static class StrengthParameterValidation
    extends SaslEnumValidator
    implements AllowedValuesValidator {
        static final StrengthParameterValidation INSTANCE = new StrengthParameterValidation();

        public StrengthParameterValidation() {
            super(SaslStrength.values(), true);
        }
    }

    private static class QopParameterValidation
    extends SaslEnumValidator
    implements AllowedValuesValidator {
        static final QopParameterValidation INSTANCE = new QopParameterValidation();

        public QopParameterValidation() {
            super(SaslQop.values(), false);
        }
    }

    private static abstract class SaslEnumValidator
    extends StringLengthValidator
    implements AllowedValuesValidator {
        final List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        SaslEnumValidator(Enum<?>[] src, boolean toLowerCase) {
            super(1);
            for (Enum<?> e : src) {
                this.allowedValues.add(new ModelNode().set(toLowerCase ? e.name().toLowerCase(Locale.ENGLISH) : e.name()));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }
}

