/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi.ir;

import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.rmi.ir.IRConstructionException;
import org.jboss.as.jacorb.rmi.ir.RepositoryImpl;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.IRObjectOperations;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

abstract class IRObjectImpl
implements IRObjectOperations {
    protected RepositoryImpl repository;
    protected final DefinitionKind def_kind;

    IRObjectImpl(DefinitionKind def_kind, RepositoryImpl repository) {
        this.def_kind = def_kind;
        this.repository = repository;
    }

    public DefinitionKind def_kind() {
        return this.def_kind;
    }

    public void destroy() {
        throw JacORBMessages.MESSAGES.cannotDestroyRMIIIOPMapping();
    }

    public abstract IRObject getReference();

    public void allDone() throws IRConstructionException {
        this.getReference();
    }

    public void shutdown() {
        POA poa = this.getPOA();
        try {
            poa.deactivate_object(poa.reference_to_id((Object)this.getReference()));
        }
        catch (UserException ex) {
            JacORBLogger.ROOT_LOGGER.warnCouldNotDeactivateIRObject(ex);
        }
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    protected ORB getORB() {
        return this.repository.orb;
    }

    protected POA getPOA() {
        return this.repository.poa;
    }

    protected abstract byte[] getObjectId();

    protected Object servantToReference(Servant servant) {
        byte[] id = this.getObjectId();
        try {
            this.repository.poa.activate_object_with_id(id, servant);
            Object ref = this.repository.poa.id_to_reference(id);
            return ref;
        }
        catch (WrongPolicy ex) {
            JacORBLogger.ROOT_LOGGER.debugExceptionConvertingServantToReference(ex);
        }
        catch (ServantAlreadyActive ex) {
            JacORBLogger.ROOT_LOGGER.debugExceptionConvertingServantToReference(ex);
        }
        catch (ObjectAlreadyActive ex) {
            JacORBLogger.ROOT_LOGGER.debugExceptionConvertingServantToReference(ex);
        }
        catch (ObjectNotActive ex) {
            JacORBLogger.ROOT_LOGGER.debugExceptionConvertingServantToReference(ex);
        }
        return null;
    }
}

