/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;

public class UntypedLuceneQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return new PathedPropertyReference(property.getText(), null, true);
        }
        return new PathedPropertyReference(property.getText(), null, false);
    }

    public boolean isPersisterReferenceAlias() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        return new PathedPropertyReference(root.getText(), null, true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        return new PathedPropertyReference(propertyName.getText(), null, false);
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return new PathedPropertyReference(propertyNameNode.getText(), null, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void pushSelectStrategy() {
    }

    public void popStrategy() {
    }

    public void propertyPathCompleted(PropertyPath path) {
    }
}

